/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.resourcepackchecker.repository;

import de.maxhenkel.resourcepackchecker.ResourcePackChecker;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_3258;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_9224;
import net.minecraft.class_9225;

public class ServerPacksCacheRepositorySource
implements class_3285 {
    private static final Pattern SHA1 = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final String CACHE_PREFIX = "cache/";
    protected Path path;

    public ServerPacksCacheRepositorySource(Path path) {
        this.path = path;
    }

    public void method_14453(Consumer<class_3288> consumer) {
        try {
            this.load(consumer);
        }
        catch (IOException e) {
            ResourcePackChecker.LOGGER.error("Error loading cached pack", (Throwable)e);
        }
    }

    private void load(Consumer<class_3288> consumer) throws IOException {
        List<Path> list = Files.list(this.path).toList();
        for (Path file : list) {
            UUID id;
            if (!Files.isDirectory(file, new LinkOption[0])) continue;
            String folder = file.getFileName().toString();
            try {
                id = UUID.fromString(folder);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            List<Path> packs = Files.list(file).toList();
            for (Path packPath : packs) {
                class_3288 pack;
                if (!SHA1.matcher(packPath.getFileName().toString()).matches() || !Files.isRegularFile(packPath, new LinkOption[0]) || (pack = this.fileToPack(id, packPath.getFileName().toString(), packPath)) == null) continue;
                consumer.accept(pack);
            }
        }
    }

    @Nullable
    private class_3288 fileToPack(UUID id, String hash, Path resourcePackFile) {
        return class_3288.method_45275((class_9224)new class_9224(ServerPacksCacheRepositorySource.idFromHash(hash), this.cachedPackName(hash), class_5352.field_25350, Optional.empty()), (class_3288.class_7680)new class_3258.class_8615(resourcePackFile), (class_3264)class_3264.field_14188, (class_9225)new class_9225(false, class_3288.class_3289.field_14280, false));
    }

    private class_2561 cachedPackName(String name) {
        return class_2564.method_10885((class_2561)class_2561.method_43471((String)"message.resourcepackchecker.cached_pack")).method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1068));
    }

    public static boolean isCached(class_3288 pack) {
        return pack.method_14463().startsWith(CACHE_PREFIX);
    }

    public static String idFromHash(String hash) {
        return CACHE_PREFIX + hash;
    }
}

