/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.capability.data;

import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityKey;
import fuzs.puzzleslib.impl.capability.GlobalCapabilityRegister;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FabricCapabilityKey<T, C extends CapabilityComponent<T>>
implements CapabilityKey<T, C> {
    private final AttachmentType<C> attachmentType;
    private final Predicate<Object> filter;
    private final Function<T, Supplier<C>> factory;

    public FabricCapabilityKey(AttachmentType<C> attachmentType, Predicate<Object> filter, Supplier<C> factory) {
        this.attachmentType = attachmentType;
        this.filter = filter;
        this.factory = holder -> () -> this.lambda$new$0((Supplier)factory, holder);
        GlobalCapabilityRegister.register(this);
    }

    public AttachmentType<C> getAttachmentType() {
        return this.attachmentType;
    }

    @Override
    public class_2960 id() {
        return this.getAttachmentType().identifier();
    }

    @Override
    public C get(@NotNull T holder) {
        Objects.requireNonNull(holder, "holder is null");
        if (this.isProvidedBy(holder)) {
            CapabilityComponent capabilityComponent = (CapabilityComponent)((AttachmentTarget)holder).getAttachedOrCreate(this.getAttachmentType(), this.factory.apply(holder));
            Objects.requireNonNull(capabilityComponent, "data is null");
            capabilityComponent.initialize(this, holder);
            return (C)capabilityComponent;
        }
        throw new IllegalArgumentException("Holder " + String.valueOf(holder) + " does not provide capability " + String.valueOf(this.id()));
    }

    @Override
    public void clear(@Nullable Object holder) {
        if (this.isProvidedBy(holder)) {
            ((AttachmentTarget)holder).removeAttached(this.getAttachmentType());
        }
    }

    @Override
    public boolean isProvidedBy(@Nullable Object holder) {
        return holder instanceof AttachmentTarget && this.filter.test(holder);
    }

    private /* synthetic */ CapabilityComponent lambda$new$0(Supplier factory, Object holder) {
        CapabilityComponent capabilityComponent = (CapabilityComponent)factory.get();
        Objects.requireNonNull(capabilityComponent, "capability component is null");
        capabilityComponent.initialize(this, holder);
        return capabilityComponent;
    }

    @FunctionalInterface
    public static interface Factory<T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> {
        public K apply(AttachmentType<C> var1, Predicate<Object> var2, Supplier<C> var3);
    }
}

