/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Cancellable;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalDoubleRef;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedDouble;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import fuzs.puzzleslib.api.event.v1.data.DefaultedValue;
import fuzs.puzzleslib.api.event.v1.data.MutableDouble;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingAttackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingExperienceDropCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingFallCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingJumpCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingKnockBackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingVisibilityCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.MobEffectEvents;
import fuzs.puzzleslib.api.event.v1.entity.living.PickProjectileCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.ShieldBlockCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.UseItemEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.fabric.impl.event.CapturedDropsEntity;
import fuzs.puzzleslib.fabric.impl.event.FabricEventImplHelper;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.event.EventImplHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
abstract class LivingEntityFabricMixin
extends class_1297 {
    @Shadow
    protected class_1799 field_6277;
    @Shadow
    protected int field_6222;
    @Shadow
    protected int field_6238;
    @Shadow
    @Final
    private Map<class_6880<class_1291>, class_1293> field_6280;
    @Unique
    private final ThreadLocal<class_1799> puzzleslib$originalUseItem = new ThreadLocal();

    public LivingEntityFabricMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    public void die(class_1282 damageSource, CallbackInfo callback) {
        EventResult eventResult = ((LivingDeathCallback)FabricLivingEvents.LIVING_DEATH.invoker()).onLivingDeath((class_1309)class_1309.class.cast((Object)this), damageSource);
        if (eventResult.isInterrupt()) {
            callback.cancel();
        }
    }

    @Inject(method={"startUsingItem"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/LivingEntity;useItemRemaining:I", shift=At.Shift.AFTER)}, cancellable=true)
    public void startUsingItem(class_1268 interactionHand, CallbackInfo callback) {
        DefaultedInt useItemRemaining = DefaultedInt.fromValue(this.field_6222);
        EventResult eventResult = ((UseItemEvents.Start)FabricLivingEvents.USE_ITEM_START.invoker()).onUseItemStart((class_1309)class_1309.class.cast((Object)this), this.field_6277, useItemRemaining);
        if (eventResult.isInterrupt()) {
            this.field_6277 = class_1799.field_8037;
            this.field_6222 = 0;
            callback.cancel();
        } else {
            this.field_6222 = useItemRemaining.getAsOptionalInt().orElse(this.field_6222);
        }
    }

    @Inject(method={"updateUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    protected void updateUsingItem(class_1799 usingItem, CallbackInfo callback) {
        if (!usingItem.method_7960()) {
            DefaultedInt remainingUseDuration = DefaultedInt.fromValue(this.method_6014());
            EventResult eventResult = ((UseItemEvents.Tick)FabricLivingEvents.USE_ITEM_TICK.invoker()).onUseItemTick((class_1309)class_1309.class.cast((Object)this), usingItem, remainingUseDuration);
            remainingUseDuration.getAsOptionalInt().ifPresent(useItemRemaining -> {
                this.field_6222 = useItemRemaining == 0 ? 1 : useItemRemaining;
            });
            if (eventResult.isInterrupt()) {
                if (--this.field_6222 == 0 && !this.method_37908().field_9236 && !usingItem.method_7967()) {
                    this.method_6040();
                }
                callback.cancel();
            }
        }
    }

    @Shadow
    public abstract int method_6014();

    @Shadow
    protected abstract void method_6040();

    @Shadow
    private void method_6076() {
        throw new RuntimeException();
    }

    @Inject(method={"completeUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;", shift=At.Shift.BEFORE)})
    protected void completeUsingItem(CallbackInfo callback) {
        this.puzzleslib$originalUseItem.set(this.field_6277.method_7972());
    }

    @ModifyVariable(method={"completeUsingItem"}, at=@At(value="STORE"), ordinal=0)
    protected class_1799 completeUsingItem(class_1799 useItem) {
        Objects.requireNonNull(this.puzzleslib$originalUseItem.get(), "use item copy is null");
        DefaultedValue<class_1799> itemStack = DefaultedValue.fromValue(useItem);
        ((UseItemEvents.Finish)FabricLivingEvents.USE_ITEM_FINISH.invoker()).onUseItemFinish((class_1309)class_1309.class.cast((Object)this), itemStack, this.puzzleslib$originalUseItem.get());
        useItem = itemStack.getAsOptional().orElse(useItem);
        this.puzzleslib$originalUseItem.remove();
        return useItem;
    }

    @Shadow
    public abstract void method_6021();

    @Inject(method={"releaseUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void releaseUsingItem(CallbackInfo callback) {
        if (!this.field_6277.method_7960()) {
            if (((UseItemEvents.Stop)FabricLivingEvents.USE_ITEM_STOP.invoker()).onUseItemStop((class_1309)class_1309.class.cast((Object)this), this.field_6277, this.field_6222).isPass()) {
                return;
            }
            if (this.field_6277.method_7967()) {
                this.method_6076();
            }
            this.method_6021();
            callback.cancel();
        }
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="HEAD")})
    protected void dropAllDeathLoot$1(class_3218 level, class_1282 damageSource, CallbackInfo callback) {
        ((CapturedDropsEntity)((Object)this)).puzzleslib$acceptCapturedDrops(new ArrayList<class_1542>());
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="TAIL")})
    protected void dropAllDeathLoot$2(class_3218 level, class_1282 damageSource, CallbackInfo callback) {
        if (!FabricEventImplHelper.tryOnLivingDrops((class_1309)class_1309.class.cast((Object)this), damageSource, this.field_6238)) {
            PuzzlesLib.LOGGER.warn("Unable to invoke LivingDropsCallback for entity {}: Drops is null", (Object)this.method_5477().getString());
        }
    }

    @Inject(method={"die"}, at={@At(value="TAIL")})
    public void die$1(class_1282 damageSource, CallbackInfo callback) {
        FabricEventImplHelper.tryOnLivingDrops((class_1309)class_1309.class.cast((Object)this), damageSource, this.field_6238);
    }

    @Inject(method={"dropExperience"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V")}, cancellable=true)
    protected void dropExperience(class_3218 serverLevel, @Nullable class_1297 killer, CallbackInfo callback) {
        DefaultedInt experienceReward = DefaultedInt.fromValue(this.method_6110(serverLevel));
        EventResult eventResult = ((LivingExperienceDropCallback)FabricLivingEvents.EXPERIENCE_DROP.invoker()).onLivingExperienceDrop((class_1309)class_1309.class.cast((Object)this), this.method_66280(), experienceReward);
        if (eventResult.isInterrupt()) {
            callback.cancel();
        } else {
            experienceReward.getAsOptionalInt().ifPresent(value -> {
                class_1303.method_31493((class_3218)((class_3218)this.method_37908()), (class_243)this.method_19538(), (int)value);
                callback.cancel();
            });
        }
    }

    @Shadow
    protected abstract int method_6110(class_3218 var1);

    @Shadow
    @Nullable
    public abstract class_1657 method_66280();

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    protected float actuallyHurt(float damageAmount, class_3218 serverLevel, class_1282 damageSource, @Cancellable CallbackInfo callback) {
        if (!this.method_5679(serverLevel, damageSource)) {
            MutableBoolean cancelInjection = new MutableBoolean();
            damageAmount = FabricEventImplHelper.onLivingHurt((class_1309)class_1309.class.cast((Object)this), serverLevel, damageSource, damageAmount, cancelInjection);
            if (cancelInjection.booleanValue()) {
                callback.cancel();
            }
        }
        return damageAmount;
    }

    @Shadow
    public abstract boolean method_5679(class_3218 var1, class_1282 var2);

    @Inject(method={"hurtServer"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurtServer(class_3218 serverLevel, class_1282 damageSource, float damageAmount, CallbackInfoReturnable<Boolean> callback) {
        EventResult eventResult = ((LivingAttackCallback)FabricLivingEvents.LIVING_ATTACK.invoker()).onLivingAttack((class_1309)class_1309.class.cast((Object)this), damageSource, damageAmount);
        if (eventResult.isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @ModifyExpressionValue(method={"applyItemBlocking"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/BlocksAttacks;resolveBlockedDamage(Lnet/minecraft/world/damagesource/DamageSource;FD)F")})
    public float applyItemBlocking(float blockedDamage, class_3218 serverLevel, class_1282 damageSource, float damageAmount, @Cancellable CallbackInfoReturnable<Float> callback) {
        DefaultedFloat blockedDamageValue = DefaultedFloat.fromValue(blockedDamage);
        EventResult eventResult = ((ShieldBlockCallback)FabricLivingEvents.SHIELD_BLOCK.invoker()).onShieldBlock((class_1309)class_1309.class.cast((Object)this), damageSource, blockedDamageValue);
        if (eventResult.isInterrupt()) {
            callback.setReturnValue((Object)Float.valueOf(0.0f));
            return 0.0f;
        }
        return blockedDamageValue.getAsFloat();
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    public void causeFallDamage(CallbackInfoReturnable<Boolean> callback, @Local(ordinal=0, argsOnly=true) LocalDoubleRef fallDistanceRef, @Local(ordinal=0, argsOnly=true) LocalFloatRef damageMultiplierRef) {
        MutableDouble fallDistance = MutableDouble.fromEvent(arg_0 -> ((LocalDoubleRef)fallDistanceRef).set(arg_0), () -> ((LocalDoubleRef)fallDistanceRef).get());
        MutableFloat damageMultiplier = MutableFloat.fromEvent(arg_0 -> ((LocalFloatRef)damageMultiplierRef).set(arg_0), () -> ((LocalFloatRef)damageMultiplierRef).get());
        EventResult eventResult = ((LivingFallCallback)FabricLivingEvents.LIVING_FALL.invoker()).onLivingFall((class_1309)class_1309.class.cast((Object)this), fallDistance, damageMultiplier);
        if (eventResult.isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(method={"knockback"}, at={@At(value="HEAD")}, cancellable=true)
    public void knockback(CallbackInfo callback, @Local(ordinal=0, argsOnly=true) LocalDoubleRef strengthRef, @Local(ordinal=1, argsOnly=true) LocalDoubleRef ratioXRef, @Local(ordinal=2, argsOnly=true) LocalDoubleRef ratioZRef) {
        MutableDouble knockbackStrength = MutableDouble.fromEvent(arg_0 -> ((LocalDoubleRef)strengthRef).set(arg_0), () -> ((LocalDoubleRef)strengthRef).get());
        MutableDouble ratioX = MutableDouble.fromEvent(arg_0 -> ((LocalDoubleRef)ratioXRef).set(arg_0), () -> ((LocalDoubleRef)ratioXRef).get());
        MutableDouble ratioZ = MutableDouble.fromEvent(arg_0 -> ((LocalDoubleRef)ratioZRef).set(arg_0), () -> ((LocalDoubleRef)ratioZRef).get());
        EventResult eventResult = ((LivingKnockBackCallback)FabricLivingEvents.LIVING_KNOCK_BACK.invoker()).onLivingKnockBack((class_1309)class_1309.class.cast((Object)this), knockbackStrength, ratioX, ratioZ);
        if (eventResult.isInterrupt()) {
            callback.cancel();
        }
    }

    @ModifyVariable(method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at=@At(value="STORE"), ordinal=1)
    public class_1293 addEffect(@Nullable class_1293 oldEffectInstance, class_1293 mobEffect, @Nullable class_1297 entity) {
        ((MobEffectEvents.Apply)FabricLivingEvents.MOB_EFFECT_APPLY.invoker()).onMobEffectApply((class_1309)class_1309.class.cast((Object)this), mobEffect, oldEffectInstance, entity);
        return oldEffectInstance;
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    public void canBeAffected(class_1293 mobEffect, CallbackInfoReturnable<Boolean> callback) {
        EventResult eventResult = ((MobEffectEvents.Affects)FabricLivingEvents.MOB_EFFECT_AFFECTS.invoker()).onMobEffectAffects((class_1309)class_1309.class.cast((Object)this), mobEffect);
        if (eventResult.isInterrupt()) {
            callback.setReturnValue((Object)eventResult.getAsBoolean());
        }
    }

    @Inject(method={"removeEffect"}, at={@At(value="HEAD")}, cancellable=true)
    public void removeEffect(class_6880<class_1291> effect, CallbackInfoReturnable<Boolean> callback) {
        EventResult eventResult = ((MobEffectEvents.Remove)FabricLivingEvents.MOB_EFFECT_REMOVE.invoker()).onMobEffectRemove((class_1309)class_1309.class.cast((Object)this), this.method_6112(effect));
        if (eventResult.isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Shadow
    @Nullable
    public abstract class_1293 method_6112(class_6880<class_1291> var1);

    @Inject(method={"removeAllEffects"}, at={@At(value="HEAD")})
    public void removeAllEffects(CallbackInfoReturnable<Boolean> callback) {
        if (this.method_37908().field_9236 || this.field_6280.isEmpty()) {
            return;
        }
        HashMap<class_6880<class_1291>, class_1293> removedActiveEffects = new HashMap<class_6880<class_1291>, class_1293>();
        for (Map.Entry<class_6880<class_1291>, class_1293> entry : this.field_6280.entrySet()) {
            EventResult eventResult = ((MobEffectEvents.Remove)FabricLivingEvents.MOB_EFFECT_REMOVE.invoker()).onMobEffectRemove((class_1309)class_1309.class.cast((Object)this), entry.getValue());
            if (!eventResult.isPass()) continue;
            removedActiveEffects.put(entry.getKey(), entry.getValue());
        }
        if (removedActiveEffects.size() != this.field_6280.size()) {
            removedActiveEffects.keySet().forEach(this.field_6280::remove);
            this.method_6129(removedActiveEffects.values());
            callback.setReturnValue((Object)true);
        }
    }

    @Shadow
    protected abstract void method_6129(Collection<class_1293> var1);

    @ModifyVariable(method={"tickEffects"}, at=@At(value="INVOKE", target="Ljava/util/Iterator;remove()V"), ordinal=0)
    protected class_1293 tickEffects(class_1293 mobEffectInstance) {
        ((MobEffectEvents.Expire)FabricLivingEvents.MOB_EFFECT_EXPIRE.invoker()).onMobEffectExpire((class_1309)class_1309.class.cast((Object)this), mobEffectInstance);
        return mobEffectInstance;
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="TAIL")})
    protected void jumpFromGround(CallbackInfo callback) {
        EventImplHelper.onLivingJump((LivingJumpCallback)FabricLivingEvents.LIVING_JUMP.invoker(), (class_1309)class_1309.class.cast((Object)this));
    }

    @ModifyVariable(method={"getVisibilityPercent"}, at=@At(value="TAIL", shift=At.Shift.BEFORE), ordinal=0)
    public double getVisibilityPercent(double value, @Nullable class_1297 lookingEntity) {
        DefaultedDouble visibilityPercentage = DefaultedDouble.fromValue(value);
        ((LivingVisibilityCallback)FabricLivingEvents.LIVING_VISIBILITY.invoker()).onLivingVisibility((class_1309)class_1309.class.cast((Object)this), lookingEntity, visibilityPercentage);
        return visibilityPercentage.getAsOptionalDouble().stream().map(visibilityPercentageValue -> Math.max(visibilityPercentageValue, 0.0)).findAny().orElse(value);
    }

    @ModifyReturnValue(method={"getProjectile"}, at={@At(value="RETURN")})
    public class_1799 getProjectile(class_1799 projectileItemStack, class_1799 weaponItemStack) {
        if (weaponItemStack.method_7909() instanceof class_1811) {
            DefaultedValue<class_1799> projectileItemStackValue = DefaultedValue.fromValue(projectileItemStack);
            ((PickProjectileCallback)FabricLivingEvents.PICK_PROJECTILE.invoker()).onPickProjectile((class_1309)class_1309.class.cast((Object)this), weaponItemStack, projectileItemStackValue);
            return projectileItemStackValue.getAsOptional().orElse(projectileItemStack);
        }
        return projectileItemStack;
    }
}

