/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.content;

import com.google.common.collect.Sets;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3162;
import net.minecraft.class_3164;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.slf4j.Logger;

public class ItemDataAccessor
implements class_3162 {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(entity -> class_2561.method_54159((String)"commands.enchant.failed.entity", (Object[])new Object[]{entity}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(entity -> class_2561.method_54159((String)"commands.enchant.failed.itemless", (Object[])new Object[]{entity}));
    public static final Function<String, class_3164.class_3167> PROVIDER = argumentName -> new class_3164.class_3167((String)argumentName){
        final /* synthetic */ String val$argumentName;
        {
            this.val$argumentName = string;
        }

        public class_3162 method_13924(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_1297 entity = class_2186.method_9313(context, (String)this.val$argumentName);
            if (!(entity instanceof class_1309)) {
                throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.method_5477().getString());
            }
            class_1309 livingEntity = (class_1309)entity;
            class_1799 itemStack = livingEntity.method_6047();
            if (itemStack.method_7960()) {
                throw ERROR_NO_ITEM.create((Object)entity.method_5477().getString());
            }
            return new ItemDataAccessor(((class_2168)context.getSource()).method_30497(), itemStack);
        }

        public ArgumentBuilder<class_2168, ?> method_13925(ArgumentBuilder<class_2168, ?> builder, Function<ArgumentBuilder<class_2168, ?>, ArgumentBuilder<class_2168, ?>> action) {
            return builder.then(class_2170.method_9247((String)"item").then(action.apply((ArgumentBuilder<class_2168, ?>)class_2170.method_9244((String)this.val$argumentName, (ArgumentType)class_2186.method_9309()))));
        }
    };
    private final class_5455 registryAccess;
    private final class_1799 itemStack;

    public ItemDataAccessor(class_5455 registryAccess, class_1799 itemStack) {
        this.registryAccess = registryAccess;
        this.itemStack = itemStack;
    }

    public void method_13880(class_2487 compoundTag) throws CommandSyntaxException {
        class_6903 registryOps = this.registryAccess.method_57093((DynamicOps)class_2509.field_11560);
        class_9323.field_50234.parse((DynamicOps)registryOps, (Object)compoundTag).resultOrPartial().ifPresent(newComponents -> {
            class_9323 oldComponents = this.itemStack.method_57353();
            this.itemStack.method_57366(this.constructDataComponentPatch(oldComponents, (class_9323)newComponents));
        });
    }

    <T> class_9326 constructDataComponentPatch(class_9323 oldComponents, class_9323 newComponents) {
        class_9326.class_9327 builder = class_9326.method_57841();
        for (class_9331 dataComponentType : Sets.union((Set)oldComponents.method_57831(), (Set)newComponents.method_57831())) {
            Object t = newComponents.method_58694(dataComponentType);
            if (!newComponents.method_57832(dataComponentType)) {
                builder.method_57853(dataComponentType);
                continue;
            }
            if (Objects.equals(oldComponents.method_58694(dataComponentType), t)) continue;
            builder.method_57854(dataComponentType, t);
        }
        return builder.method_57852();
    }

    public class_2487 method_13881() {
        class_6903 registryOps = this.registryAccess.method_57093((DynamicOps)class_2509.field_11560);
        return class_9323.field_50234.encodeStart((DynamicOps)registryOps, (Object)this.itemStack.method_57353()).resultOrPartial(arg_0 -> ((Logger)PuzzlesLib.LOGGER).error(arg_0)).map(tag -> {
            class_2487 compoundTag;
            return tag instanceof class_2487 ? (compoundTag = (class_2487)tag) : null;
        }).orElseGet(class_2487::new);
    }

    public class_2561 method_13883() {
        return class_2561.method_43469((String)"commands.data.entity.modified", (Object[])new Object[]{this.itemStack.method_7954()});
    }

    public class_2561 method_13882(class_2520 tag) {
        return class_2561.method_43469((String)"commands.data.entity.query", (Object[])new Object[]{this.itemStack.method_7954(), class_2512.method_32270((class_2520)tag)});
    }

    public class_2561 method_13879(class_2203.class_2209 path, double scale, int value) {
        return class_2561.method_43469((String)"commands.data.entity.get", (Object[])new Object[]{path.method_54100(), this.itemStack.method_7954(), String.format(Locale.ROOT, "%.2f", scale), value});
    }
}

