/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.cicada.util;

import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import nl.enjarai.cicada.Cicada;
import nl.enjarai.cicada.util.CapeMeta;

@Environment(value=EnvType.CLIENT)
public final class CapeHandler {
    private static final String META_URL = "https://enjarai.dev/cicada-lib/meta/capes/%s/meta.json";
    private static final String CAPE_URL = "https://enjarai.dev/cicada-lib/meta/capes/%s/cape.png";
    private static final String DECORATIONS_URL = "https://enjarai.dev/cicada-lib/meta/capes/%s/decorations.png";
    private static final ExecutorService capeExecutor = Executors.newFixedThreadPool(2);
    private static final HashMap<UUID, CapeHandler> instances = new HashMap();
    private static boolean sillyHairsFailed = false;
    private final UUID uuid;
    private boolean hasCape = false;
    private boolean hasElytra = false;
    private boolean hasDecorations = false;
    private CapeMeta meta;

    public static void shutdown() {
        capeExecutor.shutdownNow();
    }

    public static CapeHandler fromProfile(GameProfile profile) {
        return instances.computeIfAbsent(profile.getId(), uuid -> new CapeHandler(profile));
    }

    public static void onLoadTexture(GameProfile profile) {
        CapeHandler handler = CapeHandler.fromProfile(profile);
        capeExecutor.submit(handler::loadCape);
    }

    private static HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection(class_310.method_1551().method_1487());
        connection.setRequestProperty("User-Agent", "Mozilla/4.0");
        connection.setDoInput(true);
        connection.setDoOutput(false);
        return connection;
    }

    public static void sillyHairsFailed() {
        sillyHairsFailed = true;
    }

    public CapeHandler(GameProfile profile) {
        this.uuid = profile.getId();
    }

    public boolean hasCape() {
        return this.hasCape;
    }

    public boolean hasElytra() {
        return this.hasElytra;
    }

    public boolean hasSillyHairs() {
        return !sillyHairsFailed && this.hasDecorations && this.meta.sillyHairs();
    }

    public boolean disableHeadOverlay() {
        return this.hasDecorations && this.meta.disableHeadOverlay();
    }

    public class_2960 getCapeTexture() {
        return Cicada.id(this.uuid.toString());
    }

    public class_2960 getDecorationsTexture() {
        return Cicada.id("decorations/" + this.uuid.toString());
    }

    private void loadCape() {
        try {
            String metaUrl = String.format(META_URL, this.uuid);
            HttpURLConnection metaConnection = CapeHandler.getConnection(metaUrl);
            this.meta = CapeMeta.fromJson(metaConnection.getInputStream());
            if (this.meta.cape() || this.meta.elytra()) {
                String capeUrl = String.format(CAPE_URL, this.uuid);
                HttpURLConnection capeConnection = CapeHandler.getConnection(capeUrl);
                this.setCapeTexture(capeConnection.getInputStream(), this.meta);
            }
            if (this.meta.sillyHairs()) {
                String decoUrl = String.format(DECORATIONS_URL, this.uuid);
                HttpURLConnection decoConnection = CapeHandler.getConnection(decoUrl);
                this.setDecorationsTexture(decoConnection.getInputStream());
            }
        }
        catch (JsonParseException | IOException throwable) {
            // empty catch block
        }
    }

    public boolean setCapeTexture(InputStream image, CapeMeta meta) {
        try {
            class_1011 cape = class_1011.method_4309((InputStream)image);
            class_310.method_1551().execute(() -> {
                class_310.method_1551().method_1531().method_4616(this.getCapeTexture(), (class_1044)new class_1043(() -> this.getCapeTexture().toString(), this.parseImg(cape, 64, 32)));
                this.hasCape = meta.cape();
                this.hasElytra = meta.elytra();
            });
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean setDecorationsTexture(InputStream image) {
        try {
            class_1011 silliness = class_1011.method_4309((InputStream)image);
            class_310.method_1551().execute(() -> {
                class_310.method_1551().method_1531().method_4616(this.getDecorationsTexture(), (class_1044)new class_1043(() -> this.getCapeTexture().toString(), this.parseImg(silliness, 64, 64)));
                this.hasDecorations = true;
            });
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private class_1011 parseImg(class_1011 img, int imageWidth, int imageHeight) {
        int srcWidth = img.method_4307();
        int srcHeight = img.method_4323();
        while (imageWidth < srcWidth || imageHeight < srcHeight) {
            imageWidth *= 2;
            imageHeight *= 2;
        }
        class_1011 imgNew = new class_1011(imageWidth, imageHeight, true);
        for (int x = 0; x < srcWidth; ++x) {
            for (int y = 0; y < srcHeight; ++y) {
                imgNew.method_61941(x, y, img.method_61940(x, y));
            }
        }
        img.close();
        return imgNew;
    }
}

