/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.inventory.sort;

import dev.terminalmc.clientsort.compat.itemlocks.ItemLocksWrapper;
import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.ContainerScreenHelper;
import dev.terminalmc.clientsort.inventory.sort.Scope;
import dev.terminalmc.clientsort.inventory.sort.SortContext;
import dev.terminalmc.clientsort.inventory.sort.SortOrder;
import dev.terminalmc.clientsort.main.MainSort;
import dev.terminalmc.clientsort.main.network.SortPayload;
import dev.terminalmc.clientsort.network.InteractionManager;
import dev.terminalmc.clientsort.platform.Services;
import dev.terminalmc.clientsort.util.SoundManager;
import dev.terminalmc.clientsort.util.inject.ISlot;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1739;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_5537;
import net.minecraft.class_746;

public class InventorySorter {
    private final ContainerScreenHelper<? extends class_465<?>> screenHelper;
    private final class_465<?> containerScreen;
    private final class_1735[] inventorySlots;
    private final class_1799[] stacks;

    public InventorySorter(ContainerScreenHelper<? extends class_465<?>> screenHelper, class_465<?> containerScreen, class_1735 originSlot) {
        this.screenHelper = screenHelper;
        this.containerScreen = containerScreen;
        this.inventorySlots = this.collectSlots(originSlot);
        this.stacks = new class_1799[this.inventorySlots.length];
        for (int i = 0; i < this.inventorySlots.length; ++i) {
            this.stacks[i] = this.inventorySlots[i].method_7677();
        }
    }

    private class_1735[] collectSlots(class_1735 originSlot) {
        class_746 player = class_310.method_1551().field_1724;
        Scope originScope = this.screenHelper.getScope(originSlot);
        if (originScope == Scope.INVALID) {
            return new class_1735[0];
        }
        ArrayList<class_1735> collectedSlots = new ArrayList<class_1735>();
        for (class_1735 slot : this.containerScreen.method_17577().field_7761) {
            if (originScope != this.screenHelper.getScope(slot) || player != null && !slot.method_7674((class_1657)player) || ItemLocksWrapper.isLocked(slot)) continue;
            collectedSlots.add(slot);
        }
        return collectedSlots.toArray(new class_1735[0]);
    }

    private void combineStacks() {
        ArrayDeque<InteractionManager.InteractionEvent> clickEvents = new ArrayDeque<InteractionManager.InteractionEvent>();
        for (int i = this.stacks.length - 1; i >= 0; --i) {
            int stackSize;
            class_1799 stack = this.stacks[i];
            if (stack.method_7960() || (stackSize = stack.method_7947()) >= stack.method_7909().method_7882()) continue;
            clickEvents.add(this.screenHelper.createClickEvent(this.inventorySlots[i], 0, class_1713.field_7790, false));
            for (int j = 0; j < i; ++j) {
                class_1799 target = this.stacks[j];
                if (target.method_7960() || target.method_7947() >= target.method_7909().method_7882() || !class_1799.method_31577((class_1799)stack, (class_1799)target)) continue;
                clickEvents.add(this.screenHelper.createClickEvent(this.inventorySlots[j], 0, class_1713.field_7790, false));
                int delta = target.method_7909().method_7882() - target.method_7947();
                delta = Math.min(delta, stackSize);
                target.method_7939(target.method_7947() + delta);
                if ((stackSize -= delta) <= 0) break;
            }
            if (clickEvents.size() <= 1) {
                clickEvents.clear();
                continue;
            }
            InteractionManager.pushAll(clickEvents);
            InteractionManager.triggerSend(InteractionManager.TriggerType.GUI_CONFIRM);
            clickEvents.clear();
            if (stackSize > 0) {
                InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[i], 0, class_1713.field_7790, false));
                stack.method_7939(stackSize);
                continue;
            }
            this.stacks[i] = class_1799.field_8037;
        }
    }

    public void sort(SortOrder sortOrder) {
        if (this.inventorySlots.length <= 1) {
            return;
        }
        this.combineStacks();
        int[] sortIds = new int[this.stacks.length];
        for (int i = 0; i < sortIds.length; ++i) {
            sortIds[i] = i;
        }
        SortContext context = new SortContext(this.containerScreen, Arrays.asList(this.inventorySlots));
        sortIds = sortOrder.sort(sortIds, this.stacks, context);
        if (Config.options().serverAcceleratedSorting && Services.PLATFORM.canSendToServer(SortPayload.TYPE)) {
            this.sortOnServer(sortIds);
        } else {
            boolean playSound;
            boolean bl = playSound = Config.options().soundEnabled && Config.options().soundVolume > 0.0f;
            if (playSound) {
                SoundManager.resetForCount(this.estimateMaxSounds());
            }
            this.sortOnClient(sortIds, playSound);
        }
    }

    protected void sortOnServer(int[] sortedIds) {
        int[] slotMapping = new int[sortedIds.length * 2];
        for (int i = 0; i < sortedIds.length; ++i) {
            class_1735 from = this.inventorySlots[sortedIds[i]];
            class_1735 to = this.inventorySlots[i];
            slotMapping[i * 2] = ((ISlot)from).clientSort$getIdInContainer();
            slotMapping[i * 2 + 1] = ((ISlot)to).clientSort$getIdInContainer();
        }
        this.screenHelper.translateSlotMapping(slotMapping);
        InteractionManager.push(() -> {
            Services.PLATFORM.sendToServer(new SortPayload(this.containerScreen.method_17577().field_7763, slotMapping));
            return InteractionManager.TICK_WAITER;
        });
    }

    private int estimateMaxSounds() {
        int stackCount = 0;
        for (class_1799 stack : this.stacks) {
            if (stack == class_1799.field_8037) continue;
            ++stackCount;
        }
        int compaction = 0;
        for (int i = 0; i < stackCount; ++i) {
            if (this.stacks[i] != class_1799.field_8037) continue;
            ++compaction;
        }
        int size = stackCount + compaction;
        size += size / 15;
        return size;
    }

    protected void sortOnClient(int[] sortedIds, boolean playSound) {
        int slotCount = this.stacks.length;
        int[] origin2Target = new int[slotCount];
        for (int i = 0; i < origin2Target.length; ++i) {
            origin2Target[sortedIds[i]] = i;
        }
        BitSet doneOrEmpty = new BitSet(slotCount * 2);
        for (int i = 0; i < slotCount; ++i) {
            if (i == sortedIds[i]) {
                doneOrEmpty.set(i);
                continue;
            }
            if (!this.stacks[i].method_7960()) continue;
            doneOrEmpty.set(slotCount + i);
        }
        class_1792 carriedItem = class_1802.field_8162;
        class_1792[] backingStacks = (class_1792[])Arrays.stream((class_1799[])this.stacks.clone()).map(class_1799::method_7909).toArray(class_1792[]::new);
        block2: for (int i = 0; i < slotCount; ++i) {
            if (doneOrEmpty.get(i)) continue;
            if (doneOrEmpty.get(slotCount + sortedIds[i])) {
                doneOrEmpty.set(sortedIds[i]);
                continue;
            }
            class_1792 temp = backingStacks[sortedIds[i]];
            backingStacks[sortedIds[i]] = carriedItem;
            carriedItem = temp;
            InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[sortedIds[i]], 0, class_1713.field_7790, playSound));
            doneOrEmpty.set(slotCount + sortedIds[i]);
            class_1799 currentStack = this.stacks[sortedIds[i]];
            class_1735 workingSlot = this.inventorySlots[sortedIds[i]];
            int id = i;
            do {
                if (this.stacks[id].method_7909() == currentStack.method_7909() && !doneOrEmpty.get(slotCount + id) && class_1799.method_31577((class_1799)this.stacks[id], (class_1799)currentStack)) {
                    if (this.stacks[id].method_7947() == currentStack.method_7947()) {
                        doneOrEmpty.set(id);
                        id = origin2Target[id];
                        continue;
                    }
                    if (currentStack.method_7947() < this.stacks[id].method_7947()) {
                        class_1735 targetSlot = this.inventorySlots[id];
                        temp = backingStacks[id];
                        backingStacks[id] = carriedItem;
                        carriedItem = temp;
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, class_1713.field_7790, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(targetSlot, 0, class_1713.field_7790, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, class_1713.field_7790, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(targetSlot, 0, class_1713.field_7790, playSound));
                        InteractionManager.push(this.screenHelper.createClickEvent(workingSlot, 0, class_1713.field_7790, playSound));
                        currentStack = this.stacks[id];
                        doneOrEmpty.set(id);
                        id = origin2Target[id];
                        continue;
                    }
                }
                if (!Config.options().rmbBundle && (backingStacks[id] instanceof class_5537 && !(carriedItem instanceof class_1739) || carriedItem instanceof class_5537 && !(backingStacks[id] instanceof class_1739))) {
                    InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[id], 1, class_1713.field_7790, playSound));
                } else {
                    InteractionManager.push(this.screenHelper.createClickEvent(this.inventorySlots[id], 0, class_1713.field_7790, playSound));
                }
                temp = backingStacks[id];
                backingStacks[id] = carriedItem;
                carriedItem = temp;
                currentStack = this.stacks[id];
                doneOrEmpty.set(id);
                if (doneOrEmpty.get(slotCount + id)) continue block2;
                id = origin2Target[id];
            } while (!doneOrEmpty.get(id));
        }
    }

    private static void logInventorySlots(class_1735[] inventorySlots) {
        StringBuilder arr = new StringBuilder("[");
        for (class_1735 inventorySlot : inventorySlots) {
            arr.append(inventorySlot.field_7874);
            arr.append(":");
            arr.append(inventorySlot.method_7677().method_7954().getString());
            arr.append(", ");
        }
        MainSort.LOG.warn((String)(arr.length() == 1 ? "[]" : arr.substring(0, arr.length() - 2) + "]"), new Object[0]);
    }
}

