/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.main.network;

import dev.terminalmc.clientsort.main.MainSort;
import dev.terminalmc.clientsort.main.network.SortPayload;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class LogicalServerNetworking {
    private LogicalServerNetworking() {
    }

    public static void onSortPayload(SortPayload payload, MinecraftServer server, class_3222 player) {
        if (player.field_7512 == null) {
            MainSort.LOG.warn("Player {} tried to sort inventory without having an open container!", player);
            return;
        }
        if (payload.syncId() == player.field_7498.field_7763) {
            server.execute(() -> LogicalServerNetworking.sort((class_1657)player, (class_1703)player.field_7498, payload.slotMapping()));
        } else if (payload.syncId() == player.field_7512.field_7763) {
            server.execute(() -> LogicalServerNetworking.sort((class_1657)player, player.field_7512, payload.slotMapping()));
        }
    }

    private static void sort(class_1657 player, class_1703 screenHandler, int[] slotMapping) {
        TreeMap<Integer, class_1735> slots = new TreeMap<Integer, class_1735>();
        TreeMap<Integer, class_1799> stacks = new TreeMap<Integer, class_1799>();
        for (class_1735 slot : screenHandler.field_7761) {
            slots.put(slot.field_7874, slot);
            stacks.put(slot.field_7874, slot.method_7677());
        }
        if (!LogicalServerNetworking.validMapping(player, slots, slotMapping)) {
            MainSort.LOG.warn("Sort payload from player {} contains invalid data, ignoring!", player);
            return;
        }
        for (int i = 0; i < slotMapping.length - 1; i += 2) {
            int originSlotId = slotMapping[i];
            int destSlotId = slotMapping[i + 1];
            ((class_1735)slots.get(destSlotId)).method_53512((class_1799)stacks.get(originSlotId));
        }
    }

    private static boolean validMapping(class_1657 player, Map<Integer, class_1735> slots, int[] slotMapping) {
        int i;
        if (slotMapping.length < 4) {
            MainSort.LOG.warn("Sort payload contains too few slots! Got {}, expected at least {}", slotMapping.length, 4);
            return false;
        }
        IntAVLTreeSet requestedSlots = new IntAVLTreeSet();
        if (!LogicalServerNetworking.validSlotId(slots, slotMapping[0])) {
            return false;
        }
        class_1735 firstSlot = slots.get(slotMapping[0]);
        class_1263 targetInv = firstSlot.field_7871;
        for (i = 0; i < slotMapping.length; i += 2) {
            int originSlotId = slotMapping[i];
            int destSlotId = slotMapping[i + 1];
            if (!LogicalServerNetworking.validSlot(slots, originSlotId, targetInv)) {
                return false;
            }
            if (!requestedSlots.add(originSlotId)) {
                MainSort.LOG.warn("Sort payload contains duplicate origin slot {}!", originSlotId);
                return false;
            }
            if (!LogicalServerNetworking.validSlot(slots, destSlotId, targetInv)) {
                return false;
            }
            if (originSlotId == destSlotId) continue;
            class_1735 originSlot = slots.get(originSlotId);
            if (!originSlot.method_7674(player)) {
                MainSort.LOG.warn("Player {} tried to sort slot {} with stack [{}], but that slot doesn't allow taking items!", player, originSlotId, originSlot.method_7677());
                return false;
            }
            class_1735 destSlot = slots.get(destSlotId);
            if (destSlot.method_7680(originSlot.method_7677())) continue;
            MainSort.LOG.warn("Player {} tried to sort slot {} with stack [{}], but that slot doesn't allow inserting the origin stack [{}]!", player, destSlotId, destSlot.method_7677(), originSlot.method_7677());
            return false;
        }
        for (i = 1; i < slotMapping.length; i += 2) {
            int destSlotId = slotMapping[i];
            if (requestedSlots.remove(destSlotId)) continue;
            MainSort.LOG.warn("Sort payload contains duplicate destination slot or slot without origin: {}!", i);
            return false;
        }
        if (!requestedSlots.isEmpty()) {
            MainSort.LOG.error("Invalid state during checking sort payload, please report this to the {} developer. Requested slots: {}", "ClientSort", requestedSlots);
            return false;
        }
        return true;
    }

    private static boolean validSlotId(Map<Integer, class_1735> slots, int slotId) {
        if (!slots.containsKey(slotId)) {
            StringBuilder sb = new StringBuilder();
            slots.keySet().forEach(key -> sb.append(key).append(", "));
            MainSort.LOG.warn("Sort payload contains invalid slot id {} not found in list [{}]!", slotId, sb.toString());
            return false;
        }
        return true;
    }

    private static boolean validSlot(Map<Integer, class_1735> slots, int slotId, class_1263 targetInv) {
        if (!LogicalServerNetworking.validSlotId(slots, slotId)) {
            return false;
        }
        class_1735 slot = slots.get(slotId);
        if (targetInv != slot.field_7871) {
            MainSort.LOG.warn("Sort payload contains slots from different inventories, first: {}, now: {}!", targetInv, slot.field_7871);
            return false;
        }
        return true;
    }

    private static void logScreenHandlerSlots(class_1703 screenHandler) {
        StringBuilder arr = new StringBuilder("[");
        for (class_1735 slot : screenHandler.field_7761) {
            arr.append(slot.field_7874);
            arr.append(":");
            arr.append(slot.method_7677().method_7954().getString());
            arr.append(", ");
        }
        MainSort.LOG.warn((String)(arr.length() == 1 ? "[]" : arr.substring(0, arr.length() - 2) + "]"), new Object[0]);
    }

    private static void logSlotMapping(int[] slotMapping) {
        StringBuilder arr = new StringBuilder("[");
        for (int i = 0; i < slotMapping.length - 1; i += 2) {
            arr.append(slotMapping[i]);
            arr.append("->");
            arr.append(slotMapping[i + 1]);
            arr.append(", ");
        }
        MainSort.LOG.warn((String)(arr.length() == 1 ? "[]" : arr.substring(0, arr.length() - 2) + "]"), new Object[0]);
    }
}

