/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.interfaces.IRenderDispatcher;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10209;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9925;
import net.minecraft.class_9958;
import net.minecraft.class_9960;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

public class RenderEventHandler
implements IRenderDispatcher {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private final List<IRenderer> overlayRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> tooltipLastRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldPostDebugRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldLayerPassRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldPreWeatherRenderers = new ArrayList<IRenderer>();
    private final List<IRenderer> worldLastRenderers = new ArrayList<IRenderer>();

    public static IRenderDispatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerGameOverlayRenderer(IRenderer renderer) {
        if (!this.overlayRenderers.contains(renderer)) {
            this.overlayRenderers.add(renderer);
        }
    }

    @Override
    public void registerTooltipLastRenderer(IRenderer renderer) {
        if (!this.tooltipLastRenderers.contains(renderer)) {
            this.tooltipLastRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldPostDebugRenderer(IRenderer renderer) {
        if (!this.worldPostDebugRenderers.contains(renderer)) {
            this.worldPostDebugRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldPreWeatherRenderer(IRenderer renderer) {
        if (!this.worldPreWeatherRenderers.contains(renderer)) {
            this.worldPreWeatherRenderers.add(renderer);
        }
    }

    @Override
    public void registerWorldLastRenderer(IRenderer renderer) {
        if (!this.worldLastRenderers.contains(renderer)) {
            this.worldLastRenderers.add(renderer);
        }
    }

    @ApiStatus.Internal
    public void onRenderGameOverlayLastDrawer(class_332 drawContext, class_310 mc, float partialTicks) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("malilib_overlay_last_drawer");
        if (!this.overlayRenderers.isEmpty()) {
            for (IRenderer renderer : this.overlayRenderers) {
                profiler.method_15400(renderer.getProfilerSectionSupplier());
                renderer.onRenderGameOverlayLastDrawer(drawContext, partialTicks, profiler, mc);
                profiler.method_15407();
            }
        }
        profiler.method_15407();
    }

    @ApiStatus.Internal
    public void onRenderGameOverlayPost(class_332 drawContext, class_310 mc, float partialTicks) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("malilib_game_overlay");
        if (!this.overlayRenderers.isEmpty()) {
            for (IRenderer renderer : this.overlayRenderers) {
                profiler.method_15400(renderer.getProfilerSectionSupplier());
                renderer.onRenderGameOverlayPostAdvanced(drawContext, partialTicks, profiler, mc);
                renderer.onRenderGameOverlayPost(drawContext);
                profiler.method_15407();
            }
        }
        profiler.method_15405("malilib_game_messages");
        InfoUtils.renderInGameMessages(drawContext);
        profiler.method_15407();
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertFirst(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertFirst(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertMiddle(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertMiddle(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipComponentInsertLast(class_1792.class_9635 context, class_1799 stack, Consumer<class_2561> list) {
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                renderer.onRenderTooltipComponentInsertLast(context, stack, list);
            }
        }
    }

    @ApiStatus.Internal
    public void onRenderTooltipLast(class_332 drawContext, class_1799 stack, int x, int y) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("malilib_tooltip");
        if (!this.tooltipLastRenderers.isEmpty()) {
            for (IRenderer renderer : this.tooltipLastRenderers) {
                profiler.method_15403(renderer.getProfilerSectionSupplier());
                renderer.onRenderTooltipLast(drawContext, stack, x, y);
            }
        }
        profiler.method_15407();
    }

    @ApiStatus.Internal
    public void runRenderWorldPostDebug(class_4587 matrices, class_4604 frustum, class_4597.class_4598 immediate, class_243 camera) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("malilib_post_debug");
        if (!this.worldPostDebugRenderers.isEmpty()) {
            for (IRenderer renderer : this.worldPostDebugRenderers) {
                profiler.method_15400(renderer.getProfilerSectionSupplier());
                renderer.onRenderWorldPostDebugRender(matrices, frustum, immediate, camera, profiler);
                profiler.method_15407();
            }
        }
        profiler.method_15407();
    }

    @ApiStatus.Internal
    public void runRenderWorldPreWeather(Matrix4f posMatrix, Matrix4f projMatrix, class_310 mc, class_9909 frameGraphBuilder, class_9960 fbSet, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
        profiler.method_15396("malilib_pre_weather");
        if (!this.worldPreWeatherRenderers.isEmpty()) {
            class_9916 pass = frameGraphBuilder.method_61911("malilib_pre_weather");
            class_9925 handleMain = fbSet.field_53091 = pass.method_61933(fbSet.field_53091);
            pass.method_61929(() -> {
                class_9958 fog = RenderSystem.getShaderFog();
                RenderSystem.setShaderFog((class_9958)class_9958.field_53065);
                class_276 fb = (class_276)handleMain.get();
                for (IRenderer renderer : this.worldPreWeatherRenderers) {
                    profiler.method_15400(renderer.getProfilerSectionSupplier());
                    renderer.onRenderWorldPreWeather(fb, posMatrix, projMatrix, frustum, camera, fog, buffers, profiler);
                    profiler.method_15407();
                }
                RenderSystem.setShaderFog((class_9958)fog);
            });
            if (!this.worldPreWeatherRenderers.isEmpty()) {
                pass.method_61924();
            }
        }
        profiler.method_15407();
    }

    @ApiStatus.Internal
    public void runRenderWorldLast(Matrix4f posMatrix, Matrix4f projMatrix, class_310 mc, class_9909 frameGraphBuilder, class_9960 fbSet, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
        profiler.method_15396("malilib_world_last");
        if (!this.worldLastRenderers.isEmpty()) {
            class_9916 pass = frameGraphBuilder.method_61911("malilib_world_last");
            class_9925 handleMain = fbSet.field_53091 = pass.method_61933(fbSet.field_53091);
            pass.method_61929(() -> {
                class_9958 fog = RenderSystem.getShaderFog();
                RenderSystem.setShaderFog((class_9958)class_9958.field_53065);
                for (IRenderer renderer : this.worldLastRenderers) {
                    profiler.method_15400(renderer.getProfilerSectionSupplier());
                    renderer.onRenderWorldLastAdvanced((class_276)handleMain.get(), posMatrix, projMatrix, frustum, camera, fog, buffers, profiler);
                    renderer.onRenderWorldLast(posMatrix, projMatrix);
                    profiler.method_15407();
                }
                RenderSystem.setShaderFog((class_9958)fog);
            });
            if (!this.worldLastRenderers.isEmpty()) {
                pass.method_61924();
            }
        }
        profiler.method_15407();
    }
}

