/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.mixin.render.IMixinAbstractTexture;
import fi.dy.masa.malilib.mixin.render.IMixinBufferBuilder;
import fi.dy.masa.malilib.render.RenderUtils;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_10539;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_8251;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import net.minecraft.class_9851;

public class RenderContext
implements AutoCloseable {
    private Supplier<String> name;
    private RenderPipeline shader;
    private BufferUsage usage;
    private GpuBuffer vertexBuffer;
    @Nullable
    private GpuBuffer indexBuffer;
    private RenderSystem.class_5590 shapeIndex;
    private VertexFormat.class_5595 indexType;
    private class_9799 alloc;
    private class_287 builder;
    private VertexFormat format;
    private VertexFormat.class_5596 drawMode;
    private class_1049 texture;
    @Nullable
    private class_9801.class_9802 sortState;
    private int textureId;
    private float[] offset;
    private float lineWidth;
    private int color;
    private boolean started;
    private int indexCount;

    public RenderContext(RenderPipeline shader) {
        this(shader, BufferUsage.STATIC_WRITE);
    }

    public RenderContext(RenderPipeline shader, BufferUsage usage) {
        this(() -> "RenderContext", shader, usage);
    }

    public RenderContext(Supplier<String> name, RenderPipeline shader, BufferUsage usage) {
        this.name = name;
        this.alloc = new class_9799(shader.getVertexFormat().getVertexSize() * 4);
        this.builder = new class_287(this.alloc, shader.getVertexFormatMode(), shader.getVertexFormat());
        this.shapeIndex = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)shader.getVertexFormatMode());
        this.indexType = this.shapeIndex.method_31924();
        this.format = shader.getVertexFormat();
        this.drawMode = shader.getVertexFormatMode();
        this.shader = shader;
        this.usage = usage;
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.sortState = null;
        this.indexCount = -1;
        this.textureId = -1;
        this.offset = new float[]{0.0f, 0.0f, 0.0f};
        this.color = -1;
        this.lineWidth = 1.0f;
        this.started = true;
    }

    public class_287 start(RenderPipeline shader) {
        return this.start(shader, BufferUsage.STATIC_WRITE);
    }

    public class_287 start(RenderPipeline shader, BufferUsage usage) {
        return this.start(() -> "RenderContext", shader, usage);
    }

    public class_287 start(Supplier<String> name, RenderPipeline shader, BufferUsage usage) {
        this.reset();
        this.name = name;
        this.alloc = new class_9799(shader.getVertexFormat().getVertexSize() * 4);
        this.builder = new class_287(this.alloc, shader.getVertexFormatMode(), shader.getVertexFormat());
        this.shapeIndex = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)shader.getVertexFormatMode());
        this.indexType = this.shapeIndex.method_31924();
        this.format = shader.getVertexFormat();
        this.drawMode = shader.getVertexFormatMode();
        this.shader = shader;
        this.usage = usage;
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.sortState = null;
        this.indexCount = -1;
        this.textureId = -1;
        this.offset = new float[]{0.0f, 0.0f, 0.0f};
        this.color = -1;
        this.lineWidth = 1.0f;
        this.started = true;
        return this.builder;
    }

    public String getName() {
        return this.name.get();
    }

    public class_287 getBuilder() {
        return this.builder;
    }

    public BufferUsage getUsage() {
        return this.usage;
    }

    public VertexFormat getVertexFormat() {
        return this.format;
    }

    public VertexFormat.class_5596 getDrawMode() {
        return this.drawMode;
    }

    public VertexFormat getShaderFormat() {
        if (this.shader != null) {
            return this.shader.getVertexFormat();
        }
        return this.format;
    }

    public VertexFormat.class_5596 getShaderDrawMode() {
        if (this.shader != null) {
            return this.shader.getVertexFormatMode();
        }
        return this.drawMode;
    }

    public RenderContext setBuilder(class_287 builder) throws RuntimeException {
        this.ensureBuilding(builder);
        this.builder = builder;
        return this;
    }

    public RenderContext lineWidth(float width) {
        this.lineWidth = Math.clamp(width, 0.0f, 25.0f);
        return this;
    }

    public RenderContext offset(float[] value) {
        if (value.length != 3) {
            value = new float[]{0.0f, 0.0f, 0.0f};
        }
        this.offset[0] = value[0];
        this.offset[1] = value[1];
        this.offset[2] = value[2];
        return this;
    }

    public RenderContext color(int color) {
        this.color = color;
        return this;
    }

    public void upload() throws RuntimeException {
        this.upload(false);
    }

    public void upload(boolean shouldResort) throws RuntimeException {
        block7: {
            this.ensureSafeNoShader();
            this.ensureBuilding(this.builder);
            try (class_9801 meshData = this.builder.method_60794();){
                if (meshData != null) {
                    this.upload(meshData, shouldResort);
                    break block7;
                }
                throw new RuntimeException("Empty Mesh Data!");
            }
        }
    }

    public void upload(class_287 builder) throws RuntimeException {
        this.upload(builder, false);
    }

    public void upload(class_287 builder, boolean shouldResort) throws RuntimeException {
        block7: {
            this.ensureSafeNoShader();
            this.ensureBuilding(builder);
            this.builder = builder;
            try (class_9801 meshData = this.builder.method_60794();){
                if (meshData != null) {
                    this.upload(meshData, shouldResort);
                    break block7;
                }
                throw new RuntimeException("Empty Mesh Data!");
            }
        }
    }

    public void upload(class_9801 meshData, boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoShader();
        if (RenderSystem.isOnRenderThread() && meshData != null) {
            int expectedSize = meshData.method_60818().remaining();
            if (this.vertexBuffer != null) {
                this.vertexBuffer.close();
            }
            if (this.indexBuffer != null) {
                this.indexBuffer.close();
                this.indexBuffer = null;
            }
            if (this.vertexBuffer == null) {
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name.get() + " VertexBuffer", BufferType.VERTICES, this.usage, expectedSize);
            } else if (this.vertexBuffer.size() < expectedSize) {
                this.vertexBuffer.close();
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name.get() + " VertexBuffer", BufferType.VERTICES, this.usage, expectedSize);
            }
            CommandEncoder encoder = RenderSystem.getDevice().createCommandEncoder();
            if (this.vertexBuffer.isClosed()) {
                throw new RuntimeException("Vertex Buffer is closed!");
            }
            encoder.writeToBuffer(this.vertexBuffer, meshData.method_60818(), 0);
            if (shouldResort && meshData.method_60821() != null) {
                if (this.indexBuffer != null && this.indexBuffer.size() >= meshData.method_60821().remaining()) {
                    if (!this.indexBuffer.isClosed()) {
                        encoder.writeToBuffer(this.indexBuffer, meshData.method_60821(), 0);
                    }
                } else {
                    if (this.indexBuffer != null) {
                        this.indexBuffer.close();
                    }
                    this.indexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name.get() + " IndexBuffer", BufferType.INDICES, this.usage, meshData.method_60821());
                }
            } else if (this.indexBuffer != null) {
                this.indexBuffer.close();
                this.indexBuffer = null;
            }
            this.indexCount = meshData.method_60822().comp_751();
            this.indexType = meshData.method_60822().comp_753();
        }
    }

    protected class_8251 createVertexSorter(float x, float y, float z) {
        return class_8251.method_49906((float)x, (float)y, (float)z);
    }

    public class_8251 createVertexSorter(class_243 pos) {
        return this.createVertexSorter(pos, class_2338.field_10980);
    }

    public class_8251 createVertexSorter(class_4184 camera) {
        return this.createVertexSorter(camera.method_19326(), class_2338.field_10980);
    }

    public class_8251 createVertexSorter(class_4184 camera, class_2338 origin) {
        return this.createVertexSorter(camera.method_19326(), origin);
    }

    public class_8251 createVertexSorter(class_243 pos, class_2338 origin) {
        return class_8251.method_49906((float)((float)(pos.field_1352 - (double)origin.method_10263())), (float)((float)(pos.field_1351 - (double)origin.method_10264())), (float)((float)(pos.field_1350 - (double)origin.method_10260())));
    }

    public void startResorting(@Nonnull class_9801 meshData, @Nonnull class_8251 sorter) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            this.sortState = meshData.method_60819(this.alloc, sorter);
            this.resortTranslucent(sorter);
        }
    }

    public boolean shouldResort() {
        return this.sortState != null;
    }

    public void resortTranslucent(@Nonnull class_8251 sorter) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            if (this.sortState == null) {
                throw new RuntimeException("Sort State is empty!");
            }
            class_9799.class_9800 result = this.sortState.method_60824(this.alloc, sorter);
            if (result != null) {
                this.uploadIndex(result);
                result.close();
            } else {
                throw new RuntimeException("Unable to Store Sorting Data in Result Buffer!");
            }
        }
    }

    public void uploadIndex(@Nonnull class_9799.class_9800 buffer) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            if (this.indexBuffer == null) {
                this.indexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name.get() + " IndexBuffer", BufferType.INDICES, BufferUsage.STATIC_WRITE, buffer.method_60817());
            } else if (!this.indexBuffer.isClosed()) {
                RenderSystem.getDevice().createCommandEncoder().writeToBuffer(this.indexBuffer, buffer.method_60817(), 0);
            } else {
                throw new RuntimeException("Index Buffer is closed!");
            }
        }
    }

    public void bindTexture(class_2960 id, int textureId, int width, int height) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (textureId < 0 || textureId > 12) {
            throw new RuntimeException("Invalid textureId of: " + textureId + " for texture: " + id.toString());
        }
        try {
            while (!this.isTextureValid(width, height)) {
                this.texture = (class_1049)RenderUtils.tex().method_4619(id);
                if (!this.isTextureValid(width, height)) continue;
                if (this.texture != null) {
                    this.texture.method_65923(class_9851.field_52396, false);
                    RenderSystem.setShaderTexture((int)textureId, (GpuTexture)this.texture.method_68004());
                }
                break;
            }
        }
        catch (Exception err) {
            throw new RuntimeException("Exception reading Texture [" + id.toString() + "]: " + err.getMessage());
        }
        if (this.texture != null) {
            this.textureId = textureId;
            RenderSystem.setShaderTexture((int)this.textureId, (GpuTexture)this.texture.method_68004());
            return;
        }
        MaLiLib.LOGGER.error("bindTexture: Error uploading texture [{}]", (Object)id.toString());
        if (this.texture != null) {
            this.texture.close();
        }
        this.texture = null;
        this.textureId = -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTextureValid(int width, int height) {
        if (this.texture == null) {
            return false;
        }
        try (class_10539 content = this.texture.method_65809(RenderUtils.mc().method_1478());){
            class_1011 image = content.comp_3447();
            if (image == null || image.method_4307() != width || image.method_4323() != height) {
                this.texture.close();
                this.texture = null;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            this.texture.close();
            this.texture = null;
            return false;
        }
        if (((IMixinAbstractTexture)this.texture).malilib_getGlTexture() != null) {
            if (!this.texture.method_68004().isClosed()) return true;
        }
        this.texture.close();
        this.texture = null;
        return false;
    }

    public void unbindTexture(@Nullable class_2960 id) {
        if (id != null) {
            RenderUtils.tex().method_4615(id);
        }
        RenderSystem.setShaderTexture((int)0, null);
    }

    public void draw() throws RuntimeException {
        this.draw(false);
    }

    public void draw(boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.ensureBuilding(this.builder);
        class_9801 meshData = this.builder.method_60794();
        if (meshData != null) {
            this.draw(meshData, shouldResort);
            meshData.close();
        }
    }

    public void draw(class_9801 meshData) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, false, false, false);
    }

    public void draw(class_9801 meshData, boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, shouldResort, false, false);
    }

    public void draw(class_9801 meshData, boolean shouldResort, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, shouldResort, false, setLineWidth);
    }

    public void draw(@Nullable class_276 otherFb, class_9801 meshData, boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(otherFb, meshData, shouldResort, false, false);
    }

    public void draw(@Nullable class_276 otherFb, class_9801 meshData, boolean shouldResort, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(otherFb, meshData, shouldResort, false, setLineWidth);
    }

    public void draw(@Nullable class_276 otherFb, class_9801 meshData, boolean shouldResort, boolean useOffset, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            if (meshData == null) {
                this.indexCount = 0;
            } else if (this.indexCount < 1) {
                this.upload(meshData, shouldResort);
            }
            if (this.indexCount > 0) {
                float[] rgba = new float[]{class_9848.method_65101((int)this.color), class_9848.method_65102((int)this.color), class_9848.method_65103((int)this.color), class_9848.method_65100((int)this.color)};
                RenderSystem.setShaderColor((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
                this.drawInternal(otherFb, useOffset, setLineWidth);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    public void drawPost() throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(null, false, false);
    }

    public void drawPost(boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(null, false, setLineWidth);
    }

    public void drawPost(@Nullable class_276 otherFb, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(otherFb, false, setLineWidth);
    }

    public void drawPost(@Nullable class_276 otherFb, boolean useOffset, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoTexture();
        if (this.indexCount > 0) {
            float[] rgba = new float[]{class_9848.method_65101((int)this.color), class_9848.method_65102((int)this.color), class_9848.method_65103((int)this.color), class_9848.method_65100((int)this.color)};
            RenderSystem.setShaderColor((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
            this.drawInternal(otherFb, useOffset, setLineWidth);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void drawInternal(@Nullable class_276 otherFb, boolean useOffset, boolean setLineWidth) throws RuntimeException {
        this.ensureSafeNoTexture();
        if (RenderSystem.isOnRenderThread()) {
            GpuTexture texture2;
            GpuTexture texture1;
            if (useOffset) {
                RenderSystem.setModelOffset((float)this.offset[0], (float)this.offset[1], (float)this.offset[2]);
            }
            class_276 mainFb = RenderUtils.fb();
            if (otherFb != null) {
                texture1 = otherFb.method_30277();
                texture2 = otherFb.field_1478 ? otherFb.method_30278() : null;
            } else {
                texture1 = mainFb.method_30277();
                texture2 = mainFb.field_1478 ? mainFb.method_30278() : null;
            }
            GpuBuffer indexBuffer = this.shapeIndex.method_68274(this.indexCount);
            try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(texture1, OptionalInt.empty(), texture2, OptionalDouble.empty());){
                pass.setPipeline(this.shader);
                if (this.textureId > -1 && this.textureId < 12 && this.texture != null) {
                    MaLiLib.LOGGER.warn("RenderContext#drawInternal() [{}] renderPass --> bindSampler({}) [{}]", (Object)this.name.get(), (Object)this.textureId, (Object)this.texture.method_68004().getLabel());
                    pass.bindSampler("Sampler" + this.textureId, this.texture.method_68004());
                }
                if (setLineWidth) {
                    float width = this.lineWidth > 0.0f ? this.lineWidth : RenderSystem.getShaderLineWidth();
                    pass.setUniform("LineWidth", new float[]{width});
                }
                pass.setVertexBuffer(0, this.vertexBuffer);
                if (this.indexBuffer == null) {
                    pass.setIndexBuffer(indexBuffer, this.shapeIndex.method_31924());
                } else {
                    pass.setIndexBuffer(this.indexBuffer, this.indexType);
                }
                pass.drawIndexed(0, this.indexCount);
            }
            if (useOffset) {
                RenderSystem.resetModelOffset();
            }
        }
    }

    private void ensureBuilding(class_287 builder) throws RuntimeException {
        if (!((IMixinBufferBuilder)builder).malilib_isBuilding()) {
            throw new RuntimeException("Buffer Builder is not building!");
        }
        if (((IMixinBufferBuilder)builder).malilib_getVertexCount() == 0) {
            throw new RuntimeException("Buffer Builder vertices are zero!");
        }
        if (((IMixinBufferBuilder)builder).malilib_getVertexPointer() == -1L) {
            throw new RuntimeException("Buffer Builder has no vertices!");
        }
    }

    private void ensureSafeNoShader() throws RuntimeException {
        if (!this.started) {
            throw new RuntimeException("Context not started!");
        }
        if (this.alloc == null) {
            throw new RuntimeException("Allocator not valid!");
        }
        if (this.builder == null) {
            throw new RuntimeException("Buffer Builder not valid!");
        }
        if (this.name.get().isEmpty()) {
            this.name = () -> "RenderContext";
        }
    }

    private void ensureSafeNoBuffer() throws RuntimeException {
        this.ensureSafeNoShader();
        if (this.shader == null) {
            throw new RuntimeException("Shader Pipeline not valid!");
        }
    }

    private void ensureSafeNoTexture() throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (this.vertexBuffer == null) {
            throw new RuntimeException("GpuBuffer not uploaded!");
        }
    }

    private void ensureSafe() {
        this.ensureSafeNoTexture();
        if (this.texture == null) {
            throw new RuntimeException("A Texture Object is expected to be bound");
        }
    }

    public void reset() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
        if (this.indexBuffer != null) {
            this.indexBuffer.close();
            this.indexBuffer = null;
        }
        if (this.sortState != null) {
            this.sortState = null;
        }
        if (this.builder != null) {
            if (((IMixinBufferBuilder)this.builder).malilib_isBuilding() && ((IMixinBufferBuilder)this.builder).malilib_getVertexCount() != 0) {
                try {
                    class_9801 meshData = this.builder.method_60794();
                    if (meshData != null) {
                        meshData.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.builder = null;
        }
        if (this.alloc != null) {
            this.alloc.close();
            this.alloc = null;
        }
        this.indexCount = -1;
        this.indexType = null;
        this.textureId = -1;
        this.offset = new float[]{0.0f, 0.0f, 0.0f};
        this.color = -1;
        this.lineWidth = 1.0f;
        this.started = false;
    }

    @Override
    public void close() throws Exception {
        if (this.texture != null) {
            this.unbindTexture(this.texture.method_65859());
            this.texture.close();
            this.texture = null;
        }
        this.reset();
    }
}

