/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.game;

import com.google.common.base.Splitter;
import fi.dy.masa.malilib.data.MaLiLibTag;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.ResourceLocation;
import fi.dy.masa.malilib.util.game.wrap.RegistryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3612;
import net.minecraft.class_5000;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_8887;
import org.apache.commons.lang3.tuple.Pair;

public class BlockUtils {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public static Optional<class_2680> getBlockStateFromString(String str) {
        int index = str.indexOf("[");
        String blockName = index != -1 ? str.substring(0, index) : str;
        ResourceLocation id = ResourceLocation.of(blockName);
        if (RegistryUtils.getBlockById(id) != null) {
            class_2248 block = RegistryUtils.getBlockById(id);
            class_2680 state = block.method_9564();
            class_2689 stateManager = block.method_9595();
            if (index != -1 && str.length() > index + 4 && str.charAt(str.length() - 1) == ']') {
                String propStr = str.substring(index + 1, str.length() - 1);
                for (String propAndVal : COMMA_SPLITTER.split((CharSequence)propStr)) {
                    Object val;
                    class_2769 prop;
                    Iterator valIter = EQUAL_SPLITTER.split((CharSequence)propAndVal).iterator();
                    if (!valIter.hasNext() || (prop = stateManager.method_11663((String)valIter.next())) == null || !valIter.hasNext() || (val = BlockUtils.getPropertyValueByName(prop, (String)valIter.next())) == null) continue;
                    state = BlockUtils.getBlockStateWithProperty(state, prop, val);
                }
            }
            return Optional.of(state);
        }
        return Optional.empty();
    }

    public static class_2487 getBlockStateTagFromString(String stateString) {
        int index = stateString.indexOf("[");
        String blockName = index != -1 ? stateString.substring(0, index) : stateString;
        class_2487 tag = new class_2487();
        tag.method_10582("Name", blockName);
        if (index != -1 && stateString.length() > index + 4 && stateString.charAt(stateString.length() - 1) == ']') {
            class_2487 propsTag = new class_2487();
            String propStr = stateString.substring(index + 1, stateString.length() - 1);
            for (String propAndVal : COMMA_SPLITTER.split((CharSequence)propStr)) {
                Iterator valIter = EQUAL_SPLITTER.split((CharSequence)propAndVal).iterator();
                if (!valIter.hasNext()) continue;
                String propName = (String)valIter.next();
                if (!valIter.hasNext()) continue;
                String valStr = (String)valIter.next();
                propsTag.method_10582(propName, valStr);
            }
            tag.method_10566("Properties", (class_2520)propsTag);
        }
        return tag;
    }

    public static String getBlockStateStringFromTag(class_2487 stateTag) {
        String name = stateTag.method_68564("Name", "");
        if (!stateTag.method_10545("Properties")) {
            return name;
        }
        class_2487 propTag = stateTag.method_68568("Properties");
        ArrayList<Pair> props = new ArrayList<Pair>();
        for (String key : propTag.method_10541()) {
            props.add(Pair.of((Object)key, (Object)propTag.method_68564(key, "")));
        }
        int size = props.size();
        if (size > 0) {
            props.sort(Comparator.comparing(Pair::getLeft));
            StringBuilder sb = new StringBuilder();
            sb.append(name).append('[');
            Pair pair = (Pair)props.get(0);
            sb.append((String)pair.getLeft()).append('=').append((String)pair.getRight());
            for (int i = 1; i < size; ++i) {
                pair = (Pair)props.get(i);
                sb.append(',').append((String)pair.getLeft()).append('=').append((String)pair.getRight());
            }
            sb.append(']');
            return sb.toString();
        }
        return name;
    }

    public static <T extends Comparable<T>> class_2680 getBlockStateWithProperty(class_2680 state, class_2769<T> prop, Comparable<?> value) {
        return (class_2680)state.method_11657(prop, value);
    }

    @Nullable
    public static <T extends Comparable<T>> T getPropertyValueByName(class_2769<T> prop, String valStr) {
        return (T)((Comparable)prop.method_11900(valStr).orElse(null));
    }

    public static Optional<class_2350> getFirstPropertyFacingValue(class_2680 state) {
        Optional<class_2754<class_2350>> propOptional = BlockUtils.getFirstDirectionProperty(state);
        return propOptional.map(directionProperty -> class_2350.method_10168((String)((class_2350)state.method_11654((class_2769)directionProperty)).method_10151()));
    }

    public static Optional<class_2754<class_2350>> getFirstDirectionProperty(class_2680 state) {
        for (class_2769 prop : state.method_28501()) {
            class_2754 ep;
            if (!(prop instanceof class_2754) || !(ep = (class_2754)prop).method_11902().equals(class_2350.class)) continue;
            return Optional.of(ep);
        }
        return Optional.empty();
    }

    public static List<String> getFormattedBlockStateProperties(class_2680 state) {
        return BlockUtils.getFormattedBlockStateProperties(state, ": ");
    }

    public static List<String> getFormattedBlockStateProperties(class_2680 state, String separator) {
        Collection properties = state.method_28501();
        if (properties.size() > 0) {
            ArrayList<String> lines = new ArrayList<String>();
            try {
                for (class_2769 prop : properties) {
                    class_2754 enumProperty;
                    Comparable val = state.method_11654(prop);
                    String key = prop instanceof class_2746 ? (val.equals(Boolean.TRUE) ? "malilib.label.block_state_properties.boolean.true" : "malilib.label.block_state_properties.boolean.false") : (prop instanceof class_2754 ? ((enumProperty = (class_2754)prop).method_11902().equals(class_2350.class) ? "malilib.label.block_state_properties.direction" : (enumProperty.method_11902().equals(class_5000.class) ? "malilib.label.block_state_properties.orientation" : "malilib.label.block_state_properties.enum")) : (prop instanceof class_2758 ? "malilib.label.block_state_properties.integer" : "malilib.label.block_state_properties.generic"));
                    lines.add(StringUtils.translate(key, prop.method_11899(), separator, val.toString().toLowerCase()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return lines;
        }
        return Collections.emptyList();
    }

    public static boolean isFluidBlock(class_2680 state) {
        return !state.method_26227().equals((Object)class_3612.field_15906.method_15785());
    }

    public static boolean isFluidSourceBlock(class_2680 state) {
        return state.method_26204() instanceof class_2404 && state.method_26227().method_15761() == 8;
    }

    @Nullable
    public static class_2350 getPropertyFacingValue(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12525) ? (class_2350)state.method_11654((class_2769)class_2741.field_12525) : null;
    }

    @Nullable
    public static class_2350 getPropertyHopperFacingValue(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12545) ? (class_2350)state.method_11654((class_2769)class_2741.field_12545) : null;
    }

    @Nullable
    public static class_2350 getPropertyHorizontalFacingValue(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12481) ? (class_2350)state.method_11654((class_2769)class_2741.field_12481) : null;
    }

    @Nullable
    public static class_5000 getPropertyOrientationValue(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_23333) ? (class_5000)state.method_11654((class_2769)class_2741.field_23333) : null;
    }

    @Nullable
    public static class_2350 getPropertyOrientationFacing(class_2680 state) {
        class_5000 o = BlockUtils.getPropertyOrientationValue(state);
        return o != null ? o.method_26426() : null;
    }

    @Nullable
    public static class_2350 getPropertyOrientationRotation(class_2680 state) {
        class_5000 o = BlockUtils.getPropertyOrientationValue(state);
        return o != null ? o.method_26428() : null;
    }

    public static boolean isFacingValidForDirection(class_1799 stack, class_2350 facing) {
        class_1792 item = stack.method_7909();
        if (!stack.method_7960() && item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            class_2680 state = block.method_9564();
            if (state.method_28498((class_2769)class_2741.field_12525)) {
                return true;
            }
            if (state.method_28498((class_2769)class_2741.field_12545) && !facing.equals((Object)class_2350.field_11036)) {
                return true;
            }
            if (state.method_28498((class_2769)class_2741.field_12481) && !facing.equals((Object)class_2350.field_11036) && !facing.equals((Object)class_2350.field_11033)) {
                return true;
            }
        }
        return false;
    }

    public static int getDirectionFacingIndex(class_1799 stack, class_2350 facing) {
        if (BlockUtils.isFacingValidForDirection(stack, facing)) {
            return facing.method_10146();
        }
        return -1;
    }

    public static boolean isFacingValidForOrientation(class_1799 stack, class_2350 facing) {
        class_1792 item = stack.method_7909();
        if (!stack.method_7960() && item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            class_2680 state = block.method_9564();
            return state.method_28498((class_2769)class_2741.field_23333);
        }
        return false;
    }

    public static int getOrientationFacingIndex(class_1799 stack, class_2350 facing) {
        class_1747 blockItem;
        class_2680 defaultState;
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747 && (defaultState = (blockItem = (class_1747)class_17922).method_7711().method_9564()).method_28498((class_2769)class_2741.field_23333)) {
            List<class_5000> list = Arrays.stream(class_5000.values()).toList();
            for (int i = 0; i < list.size(); ++i) {
                class_5000 o = list.get(i);
                if (!o.method_26426().equals((Object)facing)) continue;
                return i;
            }
        }
        return -1;
    }

    public static Set<Integer> getDisabledSlots(class_8887 ce) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (ce != null) {
            for (int i = 0; i < 9; ++i) {
                if (!ce.method_54483(i)) continue;
                list.add(i);
            }
        }
        return list;
    }

    public static void setStackNbt(@Nonnull class_1799 stack, @Nonnull class_2586 be, @Nonnull class_5455 registry) {
        class_2487 nbt = be.method_58692((class_7225.class_7874)registry);
        class_1747.method_57338((class_1799)stack, (class_2591)be.method_11017(), (class_2487)nbt);
        stack.method_57365(be.method_57590());
    }

    public static boolean isInSameGroup(class_2680 left, class_2680 right) {
        for (class_6862 tagKey : MaLiLibTag.Blocks.REPLACEABLE_GROUPS) {
            if (!left.method_26164(tagKey) || !right.method_26164(tagKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchPropertiesOnly(class_2680 left, class_2680 right) {
        return BlockUtils.compareProperties(left, right) && BlockUtils.compareProperties(right, left);
    }

    public static <T extends Comparable<T>> boolean compareProperties(class_2680 state, class_2680 otherState) {
        Collection props = state.method_28501();
        for (class_2769 entry : props) {
            class_2769 p = entry;
            if (otherState.method_28498(p)) {
                Comparable value = state.method_11654(p);
                if (value.equals(otherState.method_11654(p))) continue;
                return false;
            }
            return false;
        }
        return true;
    }
}

