/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.game;

import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class RayTraceUtils {
    public static final class_2680 BLOCK_STATE_AIR = class_2246.field_10124.method_9564();
    public static final BlockStatePredicate BLOCK_FILTER_ANY = state -> true;
    public static final BlockStatePredicate BLOCK_FILTER_NON_AIR = state -> state.method_26204().method_9564() != BLOCK_STATE_AIR;

    public static class_239 getRayTraceFromEntity(class_1937 world, class_1297 entity, RayTraceFluidHandling fluidHandling) {
        double d;
        if (entity instanceof class_1657) {
            class_1657 pe = (class_1657)entity;
            d = pe.method_55754() + 1.0;
        } else {
            d = 5.0;
        }
        return RayTraceUtils.getRayTraceFromEntity(world, entity, fluidHandling, true, d);
    }

    public static class_239 getRayTraceFromEntity(class_1937 world, class_1297 entity, RayTraceFluidHandling fluidHandling, boolean includeEntities, double maxRange) {
        class_243 eyesPos = entity.method_33571();
        class_243 rangedLook = MathUtils.scale(MathUtils.getRotationVector(entity.method_36454(), entity.method_36455()), maxRange);
        class_243 lookEndPos = eyesPos.method_1019(rangedLook);
        class_239 result = RayTraceUtils.rayTraceBlocks(world, eyesPos, lookEndPos, fluidHandling, false, false, null, 1000);
        if (includeEntities) {
            class_238 bb = entity.method_5829().method_1009(rangedLook.field_1352, rangedLook.field_1351, rangedLook.field_1350).method_1009(1.0, 1.0, 1.0);
            List list = world.method_8335(entity, bb);
            double closest = result != null && result.method_17783() == class_239.class_240.field_1332 ? eyesPos.method_1025(result.method_17784()) : Double.MAX_VALUE;
            class_3966 entityTrace = null;
            class_1297 targetEntity = null;
            for (class_1297 entityTmp : list) {
                class_3966 traceTmp;
                double distance;
                bb = entityTmp.method_5829();
                Optional opt = bb.method_992(eyesPos, lookEndPos);
                if (!opt.isPresent() || !((distance = eyesPos.method_1025((traceTmp = new class_3966(entityTmp, (class_243)opt.get())).method_17784())) < closest)) continue;
                targetEntity = entityTmp;
                entityTrace = traceTmp;
                closest = distance;
            }
            if (targetEntity != null) {
                result = new class_3966(targetEntity, entityTrace.method_17784());
            }
        }
        if (result == null || eyesPos.method_1022(result.method_17784()) > maxRange) {
            result = null;
        }
        return result;
    }

    @Nullable
    public static class_239 rayTraceBlocks(class_1937 world, class_243 start, class_243 end, RayTraceFluidHandling fluidMode, boolean ignoreNonCollidable, boolean returnLastUncollidableBlock, @Nullable LayerRange layerRange, int maxSteps) {
        return RayTraceUtils.rayTraceBlocks(world, start, end, RayTraceCalculationData::checkRayCollision, fluidMode, BLOCK_FILTER_ANY, ignoreNonCollidable, returnLastUncollidableBlock, layerRange, maxSteps);
    }

    @Nullable
    public static class_239 rayTraceBlocks(class_1937 world, class_243 start, class_243 end, IRayPositionHandler handler, RayTraceFluidHandling fluidMode, BlockStatePredicate blockFilter, boolean ignoreNonCollidable, boolean returnLastUncollidableBlock, @Nullable LayerRange layerRange, int maxSteps) {
        if (Double.isNaN(start.field_1352) || Double.isNaN(start.field_1351) || Double.isNaN(start.field_1350) || Double.isNaN(end.field_1352) || Double.isNaN(end.field_1351) || Double.isNaN(end.field_1350)) {
            return null;
        }
        RayTraceCalculationData data = new RayTraceCalculationData(start, end, fluidMode, blockFilter, layerRange);
        while (--maxSteps >= 0) {
            if (handler.handleRayTracePosition(data, world, ignoreNonCollidable)) {
                return data.trace;
            }
            if (!RayTraceUtils.rayTraceAdvance(data)) continue;
        }
        if (returnLastUncollidableBlock) {
            class_243 pos = new class_243(data.currentX, data.currentY, data.currentZ);
            return class_3965.method_17778((class_243)pos, (class_2350)data.facing, (class_2338)data.mutablePos.method_10062());
        }
        return null;
    }

    public static boolean checkRayCollision(RayTraceCalculationData data, class_1937 world, boolean ignoreNonCollidable) {
        class_3965 traceTmp;
        class_2680 state;
        if (data.isPositionWithinRange() && data.isValidBlock(state = world.method_8320((class_2338)data.mutablePos)) && (!ignoreNonCollidable && state.method_26204().method_9564() != BLOCK_STATE_AIR || state.method_26220((class_1922)world, (class_2338)data.mutablePos) != class_259.method_1073()) && (state.method_28501().contains(class_2741.field_12508) || data.fluidMode.handled(state)) && (traceTmp = state.method_26224((class_1922)world, data.mutablePos.method_10062()).method_1092(data.start, data.end, data.mutablePos.method_10062())) != null) {
            data.trace = traceTmp;
            return true;
        }
        return false;
    }

    public static boolean rayTraceAdvance(RayTraceCalculationData data) {
        boolean hasDistToEndX = true;
        boolean hasDistToEndY = true;
        boolean hasDistToEndZ = true;
        double nextX = 999.0;
        double nextY = 999.0;
        double nextZ = 999.0;
        if (Double.isNaN(data.currentX) || Double.isNaN(data.currentY) || Double.isNaN(data.currentZ)) {
            data.trace = null;
            return true;
        }
        if (data.blockX == data.endBlockX && data.blockY == data.endBlockY && data.blockZ == data.endBlockZ) {
            return true;
        }
        if (data.endBlockX > data.blockX) {
            nextX = (double)data.blockX + 1.0;
        } else if (data.endBlockX < data.blockX) {
            nextX = (double)data.blockX + 0.0;
        } else {
            hasDistToEndX = false;
        }
        if (data.endBlockY > data.blockY) {
            nextY = (double)data.blockY + 1.0;
        } else if (data.endBlockY < data.blockY) {
            nextY = (double)data.blockY + 0.0;
        } else {
            hasDistToEndY = false;
        }
        if (data.endBlockZ > data.blockZ) {
            nextZ = (double)data.blockZ + 1.0;
        } else if (data.endBlockZ < data.blockZ) {
            nextZ = (double)data.blockZ + 0.0;
        } else {
            hasDistToEndZ = false;
        }
        double relStepX = 999.0;
        double relStepY = 999.0;
        double relStepZ = 999.0;
        double distToEndX = data.end.field_1352 - data.currentX;
        double distToEndY = data.end.field_1351 - data.currentY;
        double distToEndZ = data.end.field_1350 - data.currentZ;
        if (hasDistToEndX) {
            relStepX = (nextX - data.currentX) / distToEndX;
        }
        if (hasDistToEndY) {
            relStepY = (nextY - data.currentY) / distToEndY;
        }
        if (hasDistToEndZ) {
            relStepZ = (nextZ - data.currentZ) / distToEndZ;
        }
        if (relStepX == -0.0) {
            relStepX = -1.0E-4;
        }
        if (relStepY == -0.0) {
            relStepY = -1.0E-4;
        }
        if (relStepZ == -0.0) {
            relStepZ = -1.0E-4;
        }
        if (relStepX < relStepY && relStepX < relStepZ) {
            data.facing = data.endBlockX > data.blockX ? class_2350.field_11039 : class_2350.field_11034;
            data.currentX = nextX;
            data.currentY += distToEndY * relStepX;
            data.currentZ += distToEndZ * relStepX;
        } else if (relStepY < relStepZ) {
            data.facing = data.endBlockY > data.blockY ? class_2350.field_11033 : class_2350.field_11036;
            data.currentX += distToEndX * relStepY;
            data.currentY = nextY;
            data.currentZ += distToEndZ * relStepY;
        } else {
            data.facing = data.endBlockZ > data.blockZ ? class_2350.field_11043 : class_2350.field_11035;
            data.currentX += distToEndX * relStepZ;
            data.currentY += distToEndY * relStepZ;
            data.currentZ = nextZ;
        }
        int x = MathUtils.floor(data.currentX) - (data.facing == class_2350.field_11034 ? 1 : 0);
        int y = MathUtils.floor(data.currentY) - (data.facing == class_2350.field_11036 ? 1 : 0);
        int z = MathUtils.floor(data.currentZ) - (data.facing == class_2350.field_11035 ? 1 : 0);
        data.setBlockPos(x, y, z);
        return false;
    }

    public static enum RayTraceFluidHandling {
        NONE(blockState -> !BlockUtils.isFluidBlock(blockState)),
        SOURCE_ONLY(BlockUtils::isFluidSourceBlock),
        ANY(BlockUtils::isFluidBlock);

        private final BlockStatePredicate predicate;

        private RayTraceFluidHandling(BlockStatePredicate predicate) {
            this.predicate = predicate;
        }

        public boolean handled(class_2680 blockState) {
            return this.predicate.test(blockState);
        }
    }

    public static interface IRayPositionHandler {
        public boolean handleRayTracePosition(RayTraceCalculationData var1, class_1937 var2, boolean var3);
    }

    public static interface BlockStatePredicate {
        public boolean test(class_2680 var1);
    }

    public static class RayTraceCalculationData {
        @Nullable
        protected final LayerRange range;
        public final RayTraceFluidHandling fluidMode;
        public final BlockStatePredicate blockFilter;
        public final class_2338.class_2339 mutablePos = new class_2338.class_2339();
        public final class_243 start;
        public final class_243 end;
        public final int endBlockX;
        public final int endBlockY;
        public final int endBlockZ;
        public int blockX;
        public int blockY;
        public int blockZ;
        public double currentX;
        public double currentY;
        public double currentZ;
        public class_2350 facing;
        @Nullable
        public class_239 trace;

        public RayTraceCalculationData(class_243 start, class_243 end, RayTraceFluidHandling fluidMode, BlockStatePredicate blockFilter, @Nullable LayerRange range) {
            this.start = start;
            this.end = end;
            this.fluidMode = fluidMode;
            this.blockFilter = blockFilter;
            this.range = range;
            this.currentX = start.field_1352;
            this.currentY = start.field_1351;
            this.currentZ = start.field_1350;
            this.endBlockX = MathUtils.floor(end.field_1352);
            this.endBlockY = MathUtils.floor(end.field_1351);
            this.endBlockZ = MathUtils.floor(end.field_1350);
            this.setBlockPos(MathUtils.floor(start.field_1352), MathUtils.floor(start.field_1351), MathUtils.floor(start.field_1350));
        }

        public void setBlockPos(int x, int y, int z) {
            this.blockX = x;
            this.blockY = y;
            this.blockZ = z;
            this.mutablePos.method_10103(this.blockX, this.blockY, this.blockZ);
        }

        public boolean isValidBlock(class_2680 state) {
            return this.blockFilter.test(state);
        }

        public boolean isPositionWithinRange() {
            return this.range == null || this.range.isPositionWithinRange(this.blockX, this.blockY, this.blockZ);
        }

        public boolean checkRayCollision(class_1937 world, boolean ignoreNonCollidable) {
            class_3965 traceTmp;
            if (!this.isPositionWithinRange()) {
                return false;
            }
            class_2680 state = world.method_8320((class_2338)this.mutablePos);
            if (state == BLOCK_STATE_AIR || !this.isValidBlock(state) || !ignoreNonCollidable && state.method_26220((class_1922)world, (class_2338)this.mutablePos) == class_259.method_1073()) {
                return false;
            }
            if ((state.method_28501().contains(class_2741.field_12508) || this.fluidMode.handled(state)) && (traceTmp = state.method_26224((class_1922)world, (class_2338)this.mutablePos).method_1092(this.start, this.end, (class_2338)this.mutablePos)) != null) {
                this.trace = traceTmp;
                return true;
            }
            return false;
        }
    }
}

