/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import fi.dy.masa.malilib.MaLiLib;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_4844;

public class NbtUtils {
    @Nullable
    public static UUID readUUID(@Nonnull class_2487 tag) {
        return NbtUtils.readUUID(tag, "UUIDM", "UUIDL");
    }

    @Nullable
    public static UUID readUUID(@Nonnull class_2487 tag, String keyM, String keyL) {
        if (tag.method_10545(keyM) && tag.method_10545(keyL)) {
            return new UUID(tag.method_68080(keyM, 0L), tag.method_68080(keyL, 0L));
        }
        return null;
    }

    public static void writeUUID(@Nonnull class_2487 tag, UUID uuid) {
        NbtUtils.writeUUID(tag, uuid, "UUIDM", "UUIDL");
    }

    public static void writeUUID(@Nonnull class_2487 tag, UUID uuid, String keyM, String keyL) {
        tag.method_10544(keyM, uuid.getMostSignificantBits());
        tag.method_10544(keyL, uuid.getLeastSignificantBits());
    }

    public static class_2487 getOrCreateCompound(@Nonnull class_2487 tagIn, String tagName) {
        class_2487 nbt;
        if (tagIn.method_10545(tagName)) {
            nbt = tagIn.method_68568(tagName);
        } else {
            nbt = new class_2487();
            tagIn.method_10566(tagName, (class_2520)nbt);
        }
        return nbt;
    }

    public static <T> class_2499 asListTag(Collection<T> values, Function<T, class_2520> tagFactory) {
        class_2499 list = new class_2499();
        for (T val : values) {
            list.add((Object)tagFactory.apply(val));
        }
        return list;
    }

    @Nullable
    public static UUID getUUIDCodec(@Nonnull class_2487 nbt) {
        return NbtUtils.getUUIDCodec(nbt, "UUID");
    }

    @Nullable
    public static UUID getUUIDCodec(@Nonnull class_2487 nbt, String key) {
        if (nbt.method_10545(key)) {
            return nbt.method_67491(key, class_4844.field_25122).orElse(null);
        }
        return null;
    }

    public static class_2487 putUUIDCodec(@Nonnull class_2487 nbtIn, @Nonnull UUID uuid, String key) {
        nbtIn.method_67494(key, class_4844.field_25122, (Object)uuid);
        return nbtIn;
    }

    @Nonnull
    public static class_2487 createBlockPos(@Nonnull class_2338 pos) {
        return NbtUtils.writeBlockPos(pos, new class_2487());
    }

    @Nonnull
    public static class_2487 createBlockPosTag(@Nonnull class_2338 pos) {
        return NbtUtils.writeBlockPos(pos, new class_2487());
    }

    @Nonnull
    public static class_2487 createBlockPosTag(@Nonnull class_2382 pos) {
        return NbtUtils.putVec3i(new class_2487(), pos);
    }

    @Nonnull
    public static class_2487 createVec3iTag(@Nonnull class_2382 pos) {
        return NbtUtils.putVec3i(new class_2487(), pos);
    }

    @Nonnull
    public static class_2487 createVec3iToArray(@Nonnull class_2382 pos, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, new class_2487(), tagName);
    }

    @Nonnull
    public static class_2487 createVec3iToArrayTag(@Nonnull class_2382 pos, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, new class_2487(), tagName);
    }

    @Nonnull
    public static class_2487 createEntityPosition(@Nonnull class_243 pos) {
        return NbtUtils.createEntityPositionToTag(pos);
    }

    @Nonnull
    public static class_2487 createEntityPositionToTag(@Nonnull class_243 pos) {
        return NbtUtils.writeVec3dToListTag(pos, new class_2487(), "Pos");
    }

    @Nonnull
    public static class_2487 putVec3i(@Nonnull class_2487 tag, @Nonnull class_2382 pos) {
        tag.method_10569("x", pos.method_10263());
        tag.method_10569("y", pos.method_10264());
        tag.method_10569("z", pos.method_10260());
        return tag;
    }

    @Nonnull
    public static class_2487 putVec2fCodec(@Nonnull class_2487 tag, @Nonnull class_241 pos, String key) {
        tag.method_67494(key, class_241.field_56695, (Object)pos);
        return tag;
    }

    @Nonnull
    public static class_2487 putVec3iCodec(@Nonnull class_2487 tag, @Nonnull class_2382 pos, String key) {
        tag.method_67494(key, class_2382.field_25123, (Object)pos);
        return tag;
    }

    @Nonnull
    public static class_2487 putVec3dCodec(@Nonnull class_2487 tag, @Nonnull class_243 pos, String key) {
        tag.method_67494(key, class_243.field_38277, (Object)pos);
        return tag;
    }

    @Nonnull
    public static class_2487 putPosCodec(@Nonnull class_2487 tag, @Nonnull class_2338 pos, String key) {
        tag.method_67494(key, class_2338.field_25064, (Object)pos);
        return tag;
    }

    public static class_241 getVec2fCodec(@Nonnull class_2487 tag, String key) {
        return tag.method_67491(key, class_241.field_56695).orElse(class_241.field_1340);
    }

    public static class_2382 getVec3iCodec(@Nonnull class_2487 tag, String key) {
        return tag.method_67491(key, class_2382.field_25123).orElse(class_2382.field_11176);
    }

    public static class_243 getVec3dCodec(@Nonnull class_2487 tag, String key) {
        return tag.method_67491(key, class_243.field_38277).orElse(class_243.field_1353);
    }

    public static class_2338 getPosCodec(@Nonnull class_2487 tag, String key) {
        return tag.method_67491(key, class_2338.field_25064).orElse(class_2338.field_10980);
    }

    @Nonnull
    public static class_2487 writeBlockPosToTag(@Nonnull class_2338 pos, @Nonnull class_2487 tag) {
        return NbtUtils.writeBlockPos(pos, tag);
    }

    @Nonnull
    public static class_2487 writeBlockPos(@Nonnull class_2338 pos, @Nonnull class_2487 tag) {
        tag.method_10569("x", pos.method_10263());
        tag.method_10569("y", pos.method_10264());
        tag.method_10569("z", pos.method_10260());
        return tag;
    }

    @Nonnull
    public static class_2487 writeBlockPosToListTag(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        class_2499 tagList = new class_2499();
        tagList.add((Object)class_2497.method_23247((int)pos.method_10263()));
        tagList.add((Object)class_2497.method_23247((int)pos.method_10264()));
        tagList.add((Object)class_2497.method_23247((int)pos.method_10260()));
        tag.method_10566(tagName, (class_2520)tagList);
        return tag;
    }

    @Nonnull
    public static class_2487 writeVec3iToArray(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, tag, tagName);
    }

    @Nonnull
    public static class_2487 writeVec3iToArrayTag(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        return NbtUtils.writeBlockPosToArrayTag(pos, tag, tagName);
    }

    @Nonnull
    public static class_2487 writeBlockPosToArrayTag(@Nonnull class_2382 pos, @Nonnull class_2487 tag, String tagName) {
        int[] arr = new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()};
        tag.method_10539(tagName, arr);
        return tag;
    }

    @Nullable
    public static class_2338 readBlockPos(@Nullable class_2487 tag) {
        if (tag != null && tag.method_10545("x") && tag.method_10545("y") && tag.method_10545("z")) {
            return new class_2338(tag.method_68083("x", 0), tag.method_68083("y", 0), tag.method_68083("z", 0));
        }
        return null;
    }

    @Nullable
    public static class_2382 readVec3i(@Nullable class_2487 tag) {
        return NbtUtils.readVec3iFromTag(tag);
    }

    @Nullable
    public static class_2382 readVec3iFromTag(@Nullable class_2487 tag) {
        if (tag != null && tag.method_10545("x") && tag.method_10545("y") && tag.method_10545("z")) {
            return new class_2382(tag.method_68083("x", 0), tag.method_68083("y", 0), tag.method_68083("z", 0));
        }
        return null;
    }

    @Nullable
    public static class_2338 readBlockPosFromListTag(@Nonnull class_2487 tag, String tagName) {
        class_2499 tagList;
        if (tag.method_10545(tagName) && (tagList = tag.method_68569(tagName)).size() == 3) {
            return new class_2338(tagList.method_68576(0, 0), tagList.method_68576(1, 0), tagList.method_68576(2, 0));
        }
        return null;
    }

    @Nullable
    public static class_2338 readBlockPosFromIntArray(@Nonnull class_2487 nbt, String key) {
        return NbtUtils.readBlockPosFromArrayTag(nbt, key);
    }

    @Nullable
    public static class_2338 readBlockPosFromArrayTag(@Nonnull class_2487 tag, String tagName) {
        int[] pos;
        if (tag.method_10545(tagName) && (pos = tag.method_10561(tagName).orElse(new int[0])).length == 3) {
            return new class_2338(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nullable
    public static class_2382 readVec3iFromIntArray(@Nonnull class_2487 nbt, String key) {
        return NbtUtils.readVec3iFromIntArrayTag(nbt, key);
    }

    @Nullable
    public static class_2382 readVec3iFromIntArrayTag(@Nonnull class_2487 tag, String tagName) {
        int[] pos;
        if (tag.method_10545(tagName) && (pos = tag.method_10561(tagName).orElse(new int[0])).length == 3) {
            return new class_2382(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nonnull
    public static class_2487 removeBlockPos(@Nonnull class_2487 tag) {
        return NbtUtils.removeBlockPosFromTag(tag);
    }

    @Nonnull
    public static class_2487 removeBlockPosFromTag(@Nonnull class_2487 tag) {
        tag.method_10551("x");
        tag.method_10551("y");
        tag.method_10551("z");
        return tag;
    }

    @Nonnull
    public static class_2487 writeEntityPosition(@Nonnull class_243 pos, @Nonnull class_2487 tag) {
        return NbtUtils.writeVec3dToListTag(pos, tag, "Pos");
    }

    @Nonnull
    public static class_2487 writeEntityPositionToTag(@Nonnull class_243 pos, @Nonnull class_2487 tag) {
        return NbtUtils.writeVec3dToListTag(pos, tag, "Pos");
    }

    @Nonnull
    public static class_2487 writeVec3dToListTag(@Nonnull class_243 pos, @Nonnull class_2487 tag) {
        return NbtUtils.writeVec3dToListTag(pos, tag, "Pos");
    }

    @Nonnull
    public static class_2487 writeVec3dToListTag(@Nonnull class_243 pos, @Nonnull class_2487 tag, String tagName) {
        class_2499 posList = new class_2499();
        posList.add((Object)class_2489.method_23241((double)pos.field_1352));
        posList.add((Object)class_2489.method_23241((double)pos.field_1351));
        posList.add((Object)class_2489.method_23241((double)pos.field_1350));
        tag.method_10566(tagName, (class_2520)posList);
        return tag;
    }

    @Nullable
    public static class_243 readVec3d(@Nullable class_2487 tag) {
        if (tag != null && tag.method_10545("dx") && tag.method_10545("dy") && tag.method_10545("dz")) {
            return new class_243(tag.method_68563("dx", 0.0), tag.method_68563("dy", 0.0), tag.method_68563("dz", 0.0));
        }
        return null;
    }

    @Nullable
    public static class_243 readVec3dFromListTag(@Nullable class_2487 tag) {
        return NbtUtils.readVec3dFromListTag(tag, "Pos");
    }

    @Nullable
    public static class_243 readEntityPositionFromTag(@Nullable class_2487 tag) {
        return NbtUtils.readVec3dFromListTag(tag, "Pos");
    }

    @Nullable
    public static class_243 readVec3dFromListTag(@Nullable class_2487 tag, String tagName) {
        class_2499 tagList;
        if (tag != null && tag.method_10545(tagName) && (tagList = tag.method_68569(tagName)).method_10711() == 6 && tagList.size() == 3) {
            return new class_243(tagList.method_68574(0, 0.0), tagList.method_68574(1, 0.0), tagList.method_68574(2, 0.0));
        }
        return null;
    }

    @Nullable
    public static class_2338 readAttachedPosFromTag(@Nonnull class_2487 tag) {
        return NbtUtils.readPrefixedPosFromTag(tag, "Tile");
    }

    @Nonnull
    public static class_2487 writeAttachedPosToTag(@Nonnull class_2338 pos, @Nonnull class_2487 tag) {
        return NbtUtils.writePrefixedPosToTag(pos, tag, "Tile");
    }

    @Nullable
    public static class_2338 readPrefixedPosFromTag(@Nonnull class_2487 tag, String pre) {
        if (tag.method_10545(pre + "X") && tag.method_10545(pre + "Y") && tag.method_10545(pre + "Z")) {
            return new class_2338(tag.method_68083(pre + "X", 0), tag.method_68083(pre + "Y", 0), tag.method_68083(pre + "Z", 0));
        }
        return null;
    }

    @Nonnull
    public static class_2487 writePrefixedPosToTag(@Nonnull class_2338 pos, @Nonnull class_2487 tag, String pre) {
        tag.method_10569(pre + "X", pos.method_10263());
        tag.method_10569(pre + "Y", pos.method_10264());
        tag.method_10569(pre + "Z", pos.method_10260());
        return tag;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static class_2487 readNbtFromFile(@Nonnull File file) {
        return NbtUtils.readNbtFromFile(file, class_2505.method_53898());
    }

    @Nullable
    public static class_2487 readNbtFromFileAsPath(@Nonnull Path file) {
        return NbtUtils.readNbtFromFileAsPath(file, class_2505.method_53898());
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static class_2487 readNbtFromFile(@Nonnull File file, class_2505 tracker) {
        FileInputStream is;
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        try {
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("readNbtFromFile: Failed to read NBT data from file '{}' (failed to create the input stream)", (Object)file.getAbsolutePath());
            return null;
        }
        class_2487 nbt = null;
        if (is != null) {
            try {
                nbt = class_2507.method_10629((InputStream)is, (class_2505)tracker);
            }
            catch (Exception e) {
                try {
                    is.close();
                    is = new FileInputStream(file);
                    nbt = class_2507.method_10633((Path)file.toPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nbt == null) {
            MaLiLib.LOGGER.warn("readNbtFromFile: Failed to read NBT data from file '{}'", (Object)file.getAbsolutePath());
        }
        return nbt;
    }

    @Nullable
    public static class_2487 readNbtFromFileAsPath(@Nonnull Path file, class_2505 tracker) {
        if (!Files.exists(file, new LinkOption[0]) || !Files.isReadable(file)) {
            return null;
        }
        try {
            return class_2507.method_10629((InputStream)Files.newInputStream(file, new OpenOption[0]), (class_2505)tracker);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.warn("readNbtFromFileAsPath: Failed to read NBT data from file '{}'", (Object)file.toString());
            return null;
        }
    }

    public static void writeCompressed(@Nonnull class_2487 tag, @Nonnull OutputStream outputStream) {
        try {
            class_2507.method_10634((class_2487)tag, (OutputStream)outputStream);
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("writeCompressed: Failed to write NBT data to output stream");
        }
    }

    public static void writeCompressed(@Nonnull class_2487 tag, @Nonnull Path file) {
        try {
            class_2507.method_30614((class_2487)tag, (Path)file);
        }
        catch (Exception err) {
            MaLiLib.LOGGER.warn("writeCompressed: Failed to write NBT data to file");
        }
    }
}

