/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import com.google.common.collect.Iterables;
import de.johni0702.minecraft.bobby.ChunkSerializer;
import de.johni0702.minecraft.bobby.FakeChunkStorage;
import de.johni0702.minecraft.bobby.VisibleChunksTracker;
import de.johni0702.minecraft.bobby.util.LimitedExecutor;
import de.johni0702.minecraft.bobby.util.RegionPos;
import io.netty.util.concurrent.DefaultThreadFactory;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2BooleanFunction;
import it.unimi.dsi.fastutil.longs.Long2LongArrayMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_4698;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Worlds
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int CONCURRENT_REGION_LOADING_JOBS = 10;
    private static final int CONCURRENT_FINGERPRINT_JOBS = 10;
    private static final int CONCURRENT_COPY_JOBS = 10;
    private static final int MATCH_THRESHOLD = 10;
    private static final int MISMATCH_THRESHOLD = 100;
    private static final int CURRENT_SAVE_VERSION = class_155.method_16673().method_37912().method_38494();
    private static final ExecutorService saveExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory("bobby-meta-saving", true));
    private static final Executor regionLoadingExecutor = new LimitedExecutor((Executor)class_156.method_27958(), 10);
    private static final Executor computeFingerprintExecutor = new LimitedExecutor((Executor)class_156.method_27958(), 10);
    private static final LimitedExecutor copyExecutor = new LimitedExecutor((Executor)class_156.method_27958(), 10);
    private static final Map<Path, Worlds> active = new HashMap<Path, Worlds>();
    private final Path directory;
    private final Path metaFile;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Int2ObjectMap<World> worlds = new Int2ObjectOpenHashMap();
    private final List<World> outdatedWorlds = new ArrayList<World>();
    private final Object2LongMap<World> pendingMergeChecks = new Object2LongLinkedOpenHashMap();
    private int nextWorldId;
    private int currentWorldId;
    private boolean dirty;
    private boolean metaDirty;
    private final Deque<Supplier<Future<?>>> workQueue = new ArrayDeque();
    private Future<?> workQueueBlockedOn;
    private final Set<RegionLoadingJob> regionLoadingJobs = new ObjectLinkedOpenHashSet();
    private final ObjectLinkedOpenHashSet<ComputeLegacyFingerprintJob> computeLegacyFingerprintJobs = new ObjectLinkedOpenHashSet(256, 0.25f);
    private long now = System.currentTimeMillis();
    private long lastSave;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Worlds getFor(Path directory) {
        Map<Path, Worlds> map = active;
        synchronized (map) {
            return active.computeIfAbsent(directory, f -> new Worlds(directory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Map<Path, Worlds> map = active;
        synchronized (map) {
            for (Worlds worlds : active.values()) {
                try {
                    worlds.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close storage at " + String.valueOf(worlds.directory), (Throwable)e);
                }
            }
            active.clear();
        }
    }

    private Worlds(Path directory) {
        this.directory = directory;
        this.metaFile = Worlds.metaFile(directory);
        this.load(this.readFromDisk());
        if (!this.outdatedWorlds.isEmpty()) {
            class_5250 text = class_2561.method_43471((String)"bobby.upgrade.required");
            class_310 client = class_310.method_1551();
            client.execute(() -> Worlds.lambda$new$1(client, (class_2561)text));
        }
    }

    public void startNewWorld() {
        if (((World)this.worlds.get((int)this.currentWorldId)).knownRegions.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            this.currentWorldId = this.nextWorldId++;
            this.worlds.put(this.currentWorldId, (Object)new World(this.currentWorldId, CURRENT_SAVE_VERSION));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Optional<class_2487>> loadTag(class_1923 chunkPos) {
        RegionPos regionPos = RegionPos.from(chunkPos);
        long regionCoord = regionPos.toLong();
        long chunkCoord = chunkPos.method_8324();
        IntArrayList worldsToLoad = null;
        ArrayList<CompletableFuture<Optional<class_2487>>> unknownAgeResults = null;
        World knownBestWorld = null;
        long knownBestAge = -1L;
        this.lock.readLock().lock();
        try {
            for (World world : this.worlds.values()) {
                if (world.id != this.currentWorldId && world.mergingIntoWorld != this.currentWorldId || !world.knownRegions.contains(regionCoord)) continue;
                Region region = (Region)world.regions.get(regionCoord);
                if (region == null) {
                    if (unknownAgeResults == null) {
                        unknownAgeResults = new ArrayList<CompletableFuture<Optional<class_2487>>>();
                    }
                    unknownAgeResults.add(world.storage.loadTag(chunkPos));
                    if (worldsToLoad == null) {
                        worldsToLoad = new IntArrayList();
                    }
                    worldsToLoad.add(world.id);
                    continue;
                }
                long age = region.chunks.get(chunkCoord);
                if (age == 0L) continue;
                if (age == 1L) {
                    if (unknownAgeResults == null) {
                        unknownAgeResults = new ArrayList();
                    }
                    unknownAgeResults.add(world.storage.loadTag(chunkPos));
                    continue;
                }
                if (age <= knownBestAge) continue;
                knownBestAge = age;
                knownBestWorld = world;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (worldsToLoad != null) {
            this.lock.writeLock().lock();
            try {
                ObjectIterator objectIterator = worldsToLoad.iterator();
                while (objectIterator.hasNext()) {
                    int id = (Integer)objectIterator.next();
                    World world = (World)this.worlds.get(id);
                    if (world == null || world.regions.get(regionCoord) != null) continue;
                    world.loadRegion(regionPos);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        if (unknownAgeResults == null) {
            if (knownBestWorld != null) {
                return knownBestWorld.storage.loadTag(chunkPos);
            }
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (knownBestWorld == null && unknownAgeResults.size() == 1) {
            return (CompletableFuture)unknownAgeResults.get(0);
        }
        CompletableFuture<Void> allDone = CompletableFuture.allOf((CompletableFuture[])unknownAgeResults.toArray(CompletableFuture[]::new));
        World fKnownBestWorld = knownBestWorld;
        long fKnownBestAge = knownBestAge;
        ArrayList<CompletableFuture<Optional<class_2487>>> fUnknownAgeResults = unknownAgeResults;
        return allDone.thenCompose(__ -> {
            class_2487 bestResult = null;
            long bestAge = -1L;
            for (CompletableFuture future : fUnknownAgeResults) {
                long age;
                class_2487 result = ((Optional)future.join()).orElse(null);
                if (result == null || (age = result.method_68080("age", 0L)) <= bestAge) continue;
                bestAge = age;
                bestResult = result;
            }
            if (fKnownBestWorld != null && fKnownBestAge > bestAge) {
                return fKnownBestWorld.storage.loadTag(chunkPos);
            }
            return CompletableFuture.completedFuture(Optional.ofNullable(bestResult));
        });
    }

    public static Path metaFile(Path directory) {
        return directory.resolve("worlds.meta");
    }

    public FakeChunkStorage getCurrentStorage() {
        assert (class_310.method_1551().method_18854());
        return ((World)this.worlds.get((int)this.currentWorldId)).storage;
    }

    public List<FakeChunkStorage> getOutdatedWorlds() {
        assert (class_310.method_1551().method_18854());
        return this.outdatedWorlds.stream().map(it -> it.storage).collect(Collectors.toList());
    }

    public void markAsUpToDate(FakeChunkStorage storage) {
        World world = this.outdatedWorlds.stream().filter(it -> it.storage == storage).findFirst().orElse(null);
        assert (world != null);
        world.version = CURRENT_SAVE_VERSION;
        world.markMetaDirty();
        for (World otherWorld : this.worlds.values()) {
            Match match = (Match)world.matchingWorlds.get(otherWorld.id);
            if (match == null) continue;
            otherWorld.matchingWorlds.put(world.id, (Object)match);
        }
        this.worlds.put(world.id, (Object)world);
        this.outdatedWorlds.remove(world);
    }

    public void saveAll() {
        ArrayList worlds;
        this.lock.readLock().lock();
        try {
            worlds = new ArrayList(this.worlds.values());
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (World world : worlds) {
            world.storage.method_23697();
        }
    }

    @Override
    public void close() throws IOException {
        assert (class_310.method_1551().method_18854());
        this.lock.writeLock().lock();
        try {
            this.saveAll();
            if (this.dirty) {
                this.scheduleSave();
            }
            CompletableFuture.supplyAsync(() -> null, saveExecutor).join();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean update() {
        assert (class_310.method_1551().method_18854());
        this.lock.writeLock().lock();
        try {
            boolean bl = this.updateWithLock();
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean updateWithLock() {
        World world;
        Region region;
        this.now = System.currentTimeMillis();
        if (this.dirty && this.now - this.lastSave > 10000L) {
            this.scheduleSave();
        }
        int misses = 0;
        ObjectListIterator fingerprintJobsIter = this.computeLegacyFingerprintJobs.iterator();
        while (fingerprintJobsIter.hasNext()) {
            ComputeLegacyFingerprintJob job = (ComputeLegacyFingerprintJob)fingerprintJobsIter.next();
            if (job.result == null) {
                if (misses++ <= 20) continue;
                break;
            }
            fingerprintJobsIter.remove();
            World world2 = job.world;
            class_1923 chunkPos = job.chunkPos;
            long fingerprint = job.result;
            if (fingerprint == 0L) {
                region = (Region)world2.regions.get(RegionPos.from(chunkPos).toLong());
                assert (region != null);
                region.chunks.remove(chunkPos.method_8324());
                region.chunkFingerprints.remove(chunkPos.method_8324());
                region.dirty = true;
                world2.markContentDirty();
            } else {
                world2.setFingerprint(chunkPos, fingerprint);
            }
            job.future.complete(fingerprint);
        }
        misses = 0;
        Iterator<RegionLoadingJob> loadingJobsIter = this.regionLoadingJobs.iterator();
        while (loadingJobsIter.hasNext()) {
            RegionLoadingJob job = loadingJobsIter.next();
            if (job.result == null) {
                if (misses++ <= 20) continue;
                break;
            }
            loadingJobsIter.remove();
            world = job.world;
            long regionCoord = job.regionPos.toLong();
            region = job.result;
            world.regions.put(regionCoord, (Object)region);
            Region updates = (Region)world.regionUpdates.remove(regionCoord);
            if (updates != null) {
                region.chunks.putAll((Map)updates.chunks);
                region.chunkFingerprints.putAll((Map)updates.chunkFingerprints);
                region.dirty = true;
                world.markContentDirty();
            }
            ((CompletableFuture)world.loadingRegions.remove(regionCoord)).complete(null);
        }
        this.processWorkQueue();
        ObjectIterator worldsIter = this.worlds.values().iterator();
        while (worldsIter.hasNext()) {
            world = (World)worldsIter.next();
            if (world.mergingIntoWorld == -1 || !this.processMerge(world)) continue;
            worldsIter.remove();
            this.metaDirty = true;
            this.dirty = true;
        }
        return this.processPendingMergeChecks();
    }

    private boolean processPendingMergeChecks() {
        Object2LongMap.Entry entry;
        boolean didMerge = false;
        ObjectIterator iter = this.pendingMergeChecks.object2LongEntrySet().iterator();
        while (iter.hasNext() && (entry = (Object2LongMap.Entry)iter.next()).getLongValue() + 1000L <= this.now) {
            boolean mismatching;
            World targetWorld = (World)entry.getKey();
            World currentWorld = (World)this.worlds.get(this.currentWorldId);
            iter.remove();
            if (targetWorld == null || currentWorld.mergingIntoWorld != -1 || targetWorld.mergingIntoWorld != -1) continue;
            Match match = targetWorld.getMatch(currentWorld);
            boolean matching = match.matching.size() - match.mismatching.size() * 2 > 10;
            boolean bl = mismatching = match.mismatching.size() - match.matching.size() * 2 > 100;
            if (matching) {
                LOGGER.info("Merging world {} into {}: {} chunks matching, {} chunks mismatching", (Object)currentWorld, (Object)targetWorld, (Object)match.matching.size(), (Object)match.mismatching.size());
                this.merge(currentWorld, targetWorld);
                didMerge = true;
                continue;
            }
            if (!mismatching) continue;
            LOGGER.info("Marking worlds {} and {} as separate: {} chunks matching, {} chunks mismatching", (Object)currentWorld, (Object)targetWorld, (Object)match.matching.size(), (Object)match.mismatching.size());
            currentWorld.nonMatchingWorlds.add(targetWorld.id);
            targetWorld.nonMatchingWorlds.add(currentWorld.id);
            currentWorld.matchingWorlds.remove(targetWorld.id);
            targetWorld.matchingWorlds.remove(currentWorld.id);
            currentWorld.metaDirty = true;
            targetWorld.metaDirty = true;
        }
        return didMerge;
    }

    private boolean processMerge(World sourceWorld) {
        World targetWorld = (World)this.worlds.get(sourceWorld.mergingIntoWorld);
        if (targetWorld == null) {
            return false;
        }
        if (sourceWorld.mergeState == null) {
            sourceWorld.mergeState = new MergeState();
        }
        MergeState state = sourceWorld.mergeState;
        while (true) {
            LOGGER.debug("Merge of {} into {} is currently in stage {} ({} regions left, {}/{}/{} jobs pending/active/done)", (Object)sourceWorld, (Object)targetWorld, (Object)state.stage, (Object)sourceWorld.regions.size(), (Object)copyExecutor.queueSize(), (Object)copyExecutor.activeWorkers(), (Object)state.finishedJobs.size());
            switch (state.stage.ordinal()) {
                case 0: {
                    for (World world : this.worlds.values()) {
                        if (world.mergingIntoWorld != sourceWorld.id) continue;
                        return false;
                    }
                    state.stage = MergeStage.BlockedByPreviouslyQueuedWrites;
                    break;
                }
                case 1: {
                    state.stage = MergeStage.WaitForPreviouslyQueuedWrites;
                    class_156.method_27958().execute(() -> {
                        sourceWorld.storage.method_23697();
                        state.stage = MergeStage.Idle;
                    });
                    break;
                }
                case 2: {
                    return false;
                }
                case 3: {
                    if (sourceWorld.knownRegions.isEmpty()) {
                        state.stage = MergeStage.DeleteSourceStorage;
                        class_156.method_27958().execute(() -> {
                            Path directory = sourceWorld.directory();
                            try {
                                boolean empty;
                                List toBeDeleted;
                                sourceWorld.storage.close();
                                try (Stream<Path> stream = Files.list(directory);){
                                    toBeDeleted = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(it -> !"worlds.meta".equals(it.getFileName().toString())).collect(Collectors.toList());
                                }
                                for (Path path : toBeDeleted) {
                                    Files.delete(path);
                                }
                                try (Stream<Path> stream = Files.list(directory);){
                                    empty = stream.findAny().isEmpty();
                                }
                                if (empty) {
                                    Files.delete(directory);
                                }
                            }
                            catch (IOException e) {
                                LOGGER.error("Failed to delete " + String.valueOf(directory), (Throwable)e);
                            }
                            state.stage = MergeStage.Done;
                        });
                        return false;
                    }
                    long regionCoord = sourceWorld.knownRegions.iterator().nextLong();
                    RegionPos regionPos = RegionPos.fromLong(regionCoord);
                    state.activeRegion = regionPos;
                    if (!sourceWorld.regions.containsKey(regionCoord)) {
                        sourceWorld.loadRegion(regionPos);
                    }
                    if (targetWorld.knownRegions.contains(regionCoord)) {
                        if (!targetWorld.regions.containsKey(regionCoord)) {
                            targetWorld.loadRegion(regionPos);
                        }
                    } else {
                        targetWorld.knownRegions.add(regionCoord);
                        targetWorld.regions.put(regionCoord, (Object)new Region());
                        targetWorld.markMetaDirty();
                    }
                    state.stage = MergeStage.WaitForRegion;
                    break;
                }
                case 4: {
                    long chunkCoord;
                    Region sourceRegion = (Region)sourceWorld.regions.get(state.activeRegion.toLong());
                    if (sourceRegion == null) {
                        return false;
                    }
                    Region targetRegion = (Region)targetWorld.regions.get(state.activeRegion.toLong());
                    if (targetRegion == null) {
                        return false;
                    }
                    for (Long2LongMap.Entry entry : sourceRegion.chunks.long2LongEntrySet()) {
                        chunkCoord = entry.getLongKey();
                        long sourceChunkAge = entry.getLongValue();
                        long targetChunkAge = targetRegion.chunks.get(chunkCoord);
                        if (targetChunkAge > sourceChunkAge) continue;
                        CopyJob copyJob = new CopyJob(sourceWorld, targetWorld, new class_1923(chunkCoord), sourceChunkAge, targetChunkAge);
                        state.activeJobs.add(copyJob);
                        copyExecutor.execute(copyJob);
                    }
                    state.stage = MergeStage.Copying;
                    break;
                }
                case 5: {
                    CopyJob job;
                    while ((job = state.activeJobs.peek()) != null && job.done) {
                        state.activeJobs.remove();
                        state.finishedJobs.add(job);
                    }
                    if (state.activeJobs.isEmpty()) {
                        state.stage = MergeStage.Syncing;
                        class_156.method_27958().execute(() -> {
                            targetWorld.storage.method_23697();
                            state.stage = MergeStage.WriteTargetMeta;
                        });
                        break;
                    }
                    return false;
                }
                case 6: {
                    return false;
                }
                case 7: {
                    long chunkCoord;
                    Region sourceRegion = (Region)sourceWorld.regions.get(state.activeRegion.toLong());
                    Region targetRegion = (Region)targetWorld.regions.get(state.activeRegion.toLong());
                    for (CopyJob job : state.finishedJobs) {
                        if (job.age == 0L) continue;
                        chunkCoord = job.chunkPos.method_8324();
                        long fingerprint = sourceRegion.chunkFingerprints.get(chunkCoord);
                        long age = job.age;
                        targetRegion.chunks.put(chunkCoord, age);
                        targetRegion.chunkFingerprints.put(chunkCoord, fingerprint);
                    }
                    state.finishedJobs.clear();
                    targetRegion.dirty = true;
                    targetWorld.markContentDirty();
                    this.scheduleSave();
                    state.stage = MergeStage.SyncTargetMeta;
                    saveExecutor.execute(() -> {
                        state.stage = MergeStage.DeleteSourceMeta;
                    });
                    break;
                }
                case 8: {
                    return false;
                }
                case 9: {
                    long regionCoord = state.activeRegion.toLong();
                    sourceWorld.knownRegions.remove(regionCoord);
                    sourceWorld.regions.remove(regionCoord);
                    sourceWorld.markContentDirty();
                    sourceWorld.markMetaDirty();
                    state.stage = MergeStage.Idle;
                    break;
                }
                case 11: {
                    for (World world : this.worlds.values()) {
                        boolean changed = false;
                        changed |= world.nonMatchingWorlds.remove(sourceWorld.id);
                        if (!(changed |= world.matchingWorlds.remove(sourceWorld.id) != null)) continue;
                        world.markMetaDirty();
                    }
                    return true;
                }
            }
        }
    }

    private void processWorkQueue() {
        assert (class_310.method_1551().method_18854());
        while (true) {
            Supplier<Future<?>> work;
            if (this.workQueueBlockedOn != null) {
                if (!this.workQueueBlockedOn.isDone()) break;
                this.workQueueBlockedOn = null;
            }
            if ((work = this.workQueue.peek()) == null) break;
            Future<?> future = work.get();
            if (future == null) {
                this.workQueue.poll();
                continue;
            }
            this.workQueueBlockedOn = future;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runOrScheduleWork(Supplier<Future<?>> work) {
        assert (class_310.method_1551().method_18854());
        if (this.workQueue.isEmpty()) {
            this.lock.writeLock().lock();
            try {
                Future<?> future = work.get();
                if (future == null) return;
                this.workQueue.addFirst(work);
                this.workQueueBlockedOn = future;
                return;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            this.workQueue.add(work);
        }
    }

    public void recheckChunks(class_1937 mcWorld, VisibleChunksTracker tracker) {
        this.runOrScheduleWork(() -> {
            tracker.forEach(chunkCoord -> {
                class_1923 chunkPos = new class_1923(chunkCoord);
                RegionPos regionPos = RegionPos.from(chunkPos);
                long regionCoord = regionPos.toLong();
                World currentWorld = (World)this.worlds.get(this.currentWorldId);
                Region region = (Region)currentWorld.regions.get(regionCoord);
                if (region == null) {
                    return;
                }
                long fingerprint = region.chunkFingerprints.get(chunkCoord);
                if (fingerprint == 0L) {
                    return;
                }
                this.observeChunk(mcWorld, chunkPos, fingerprint);
            });
            return null;
        });
    }

    public void observeChunk(class_1937 mcWorld, class_1923 chunkPos, long fingerprint) {
        assert (class_310.method_1551().method_18854());
        this.runOrScheduleWork(() -> this.tryObserveChunk(mcWorld, chunkPos, fingerprint));
    }

    private CompletableFuture<?> tryObserveChunk(class_1937 mcWorld, class_1923 chunkPos, long fingerprint) {
        assert (this.lock.isWriteLockedByCurrentThread());
        World currentWorld = (World)this.worlds.get(this.currentWorldId);
        currentWorld.setFingerprint(chunkPos, fingerprint);
        if (this.worlds.size() == currentWorld.nonMatchingWorlds.size() + 1) {
            return null;
        }
        RegionPos regionPos = RegionPos.from(chunkPos);
        long regionCoord = regionPos.toLong();
        long chunkCoord = chunkPos.method_8324();
        Predicate<World> couldWorldMatch = world -> {
            if (world == currentWorld) {
                return false;
            }
            if (world.mergingIntoWorld != -1) {
                return false;
            }
            if (currentWorld.nonMatchingWorlds.contains(world.id)) {
                return false;
            }
            return world.knownRegions.contains(regionCoord);
        };
        for (World world2 : this.worlds.values()) {
            boolean changed;
            if (!couldWorldMatch.test(world2)) continue;
            Region region = (Region)world2.regions.get(regionCoord);
            if (region == null) {
                return CompletableFuture.allOf((CompletableFuture[])this.worlds.values().stream().filter(couldWorldMatch).filter(it -> !it.regions.containsKey(regionCoord)).map(it -> it.loadRegion(regionPos)).toArray(CompletableFuture[]::new));
            }
            if (!region.chunks.containsKey(chunkCoord)) continue;
            long worldChunkHash = region.chunkFingerprints.get(chunkCoord);
            if (worldChunkHash == 0L) {
                return this.computeLegacyFingerprint(world2, chunkPos, mcWorld);
            }
            if (fingerprint == 1L && worldChunkHash == 1L) continue;
            Match match = world2.getMatch(currentWorld);
            if (worldChunkHash == fingerprint) {
                changed = match.matching.add(chunkCoord);
                if (match.matching.size() > 10 && !this.pendingMergeChecks.containsKey((Object)world2)) {
                    this.pendingMergeChecks.put((Object)world2, this.now);
                }
            } else {
                changed = match.mismatching.add(chunkCoord);
                if (match.mismatching.size() > 100 && !this.pendingMergeChecks.containsKey((Object)world2)) {
                    this.pendingMergeChecks.put((Object)world2, this.now);
                }
            }
            if (!changed) continue;
            world2.metaDirty = true;
            currentWorld.metaDirty = true;
        }
        return null;
    }

    private void merge(World sourceWorld, World targetWorld) {
        while (targetWorld.mergingIntoWorld != -1) {
            targetWorld = (World)this.worlds.get(targetWorld.mergingIntoWorld);
        }
        sourceWorld.mergingIntoWorld = targetWorld.id;
        sourceWorld.metaDirty = true;
        for (World world : this.worlds.values()) {
            if (world.mergingIntoWorld != sourceWorld.id) continue;
            world.mergingIntoWorld = targetWorld.id;
            world.metaDirty = true;
        }
        if (sourceWorld.id == this.currentWorldId) {
            this.currentWorldId = targetWorld.id;
            this.metaDirty = true;
            this.dirty = true;
        }
    }

    private CompletableFuture<?> computeLegacyFingerprint(World world, class_1923 chunkPos, class_1937 mcWorld) {
        ComputeLegacyFingerprintJob newJob = new ComputeLegacyFingerprintJob(world, chunkPos, mcWorld);
        ComputeLegacyFingerprintJob existingJob = (ComputeLegacyFingerprintJob)this.computeLegacyFingerprintJobs.addOrGet((Object)newJob);
        if (existingJob != newJob) {
            return existingJob.future;
        }
        computeFingerprintExecutor.execute(newJob);
        return newJob.future;
    }

    private void scheduleSave() {
        this.lastSave = this.now;
        this.dirty = false;
        for (World world : this.worlds.values()) {
            this.metaDirty |= world.metaDirty;
            world.metaDirty = false;
            if (!world.contentDirty) continue;
            world.contentDirty = false;
            for (Long2ObjectMap.Entry entry : world.regions.long2ObjectEntrySet()) {
                long regionCoord = entry.getLongKey();
                Region region = (Region)entry.getValue();
                if (!region.dirty) continue;
                region.dirty = false;
                class_2487 nbt = region.saveToNbt();
                saveExecutor.execute(() -> {
                    RegionPos regionPos = RegionPos.fromLong(regionCoord);
                    try {
                        world.writeRegionToDisk(regionPos, nbt);
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to save " + String.valueOf(world.regionFile(regionPos)), (Throwable)e);
                    }
                });
            }
        }
        if (this.metaDirty) {
            this.metaDirty = false;
            class_2487 nbt = this.saveToNbt();
            saveExecutor.execute(() -> {
                try {
                    this.writeToDisk(nbt);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to save worlds metadata to " + String.valueOf(this.metaFile), (Throwable)e);
                }
            });
        }
    }

    private class_2487 readFromDisk() {
        if (Files.exists(this.metaFile, new LinkOption[0])) {
            class_2487 class_24872;
            block9: {
                InputStream in = Files.newInputStream(this.metaFile, new OpenOption[0]);
                try {
                    class_24872 = class_2507.method_10629((InputStream)in, (class_2505)class_2505.method_53898());
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to read " + String.valueOf(this.metaFile), (Throwable)e);
                    }
                }
                in.close();
            }
            return class_24872;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDisk(class_2487 nbt) throws IOException {
        Files.createDirectories(this.directory, new FileAttribute[0]);
        Path tmpFile = Files.createTempFile(this.directory, "worlds", ".meta", new FileAttribute[0]);
        try {
            try (OutputStream out = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                class_2507.method_10634((class_2487)nbt, (OutputStream)out);
            }
            Files.move(tmpFile, this.metaFile, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
    }

    private class_2487 saveToNbt() {
        class_2487 root = new class_2487();
        class_2499 worldsNbt = new class_2499();
        for (World world : Iterables.concat((Iterable)this.worlds.values(), this.outdatedWorlds)) {
            class_2487 worldNbt = new class_2487();
            worldNbt.method_10569("id", world.id);
            worldNbt.method_10569("version", world.version);
            worldNbt.method_10564("regions", world.knownRegions.toLongArray());
            if (world.mergingIntoWorld != -1) {
                worldNbt.method_10569("merging_into", world.mergingIntoWorld);
            }
            class_2499 matchesNbt = new class_2499();
            for (Int2ObjectMap.Entry entry : world.matchingWorlds.int2ObjectEntrySet()) {
                int otherWorldId = entry.getIntKey();
                Match match = (Match)entry.getValue();
                class_2487 matchNbt = new class_2487();
                matchNbt.method_10569("world", otherWorldId);
                matchNbt.method_10564("matching", match.matching.toLongArray());
                matchNbt.method_10564("mismatching", match.mismatching.toLongArray());
                matchesNbt.add((Object)matchNbt);
            }
            worldNbt.method_10566("matches", (class_2520)matchesNbt);
            worldNbt.method_10539("non_matching", world.nonMatchingWorlds.toIntArray());
            worldsNbt.add((Object)worldNbt);
        }
        root.method_10566("worlds", (class_2520)worldsNbt);
        root.method_10569("next_world", this.nextWorldId);
        return root;
    }

    private void load(class_2487 root) {
        if (root == null && !Files.exists(this.directory, new LinkOption[0])) {
            this.nextWorldId = 1;
        } else if (root == null) {
            this.outdatedWorlds.add(new World(0, 0));
            try (Stream<Path> stream = Files.list(this.directory);){
                stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMapToInt(dir -> {
                    String name = dir.getFileName().toString();
                    try {
                        return IntStream.of(Integer.parseInt(name));
                    }
                    catch (NumberFormatException e) {
                        return IntStream.of(new int[0]);
                    }
                }).forEach(id -> this.outdatedWorlds.add(new World(id, 0)));
            }
            catch (IOException e) {
                LOGGER.error("Failed to list files in " + String.valueOf(this.directory), (Throwable)e);
            }
            for (World world : this.outdatedWorlds) {
                Path worldDirectory = world.directory();
                try {
                    for (RegionPos region : FakeChunkStorage.getRegions(worldDirectory)) {
                        world.knownRegions.add(region.toLong());
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to list files in " + String.valueOf(worldDirectory), (Throwable)e);
                }
            }
            this.nextWorldId = this.outdatedWorlds.stream().mapToInt(it -> it.id).max().orElse(0) + 1;
        } else {
            for (class_2520 worldNbtElement : root.method_68569("worlds")) {
                class_2487 worldNbt = (class_2487)worldNbtElement;
                int id2 = (Integer)worldNbt.method_10550("id").orElseThrow();
                int version = (Integer)worldNbt.method_10550("version").orElseThrow();
                World world = new World(id2, version);
                world.knownRegions.addAll((LongCollection)LongArrayList.wrap((long[])((long[])worldNbt.method_10565("regions").orElseThrow())));
                worldNbt.method_10550("merging_into").ifPresent(it -> {
                    world.mergingIntoWorld = it;
                });
                for (class_2520 matchNbtElement : (class_2499)worldNbt.method_10554("matches").orElseThrow()) {
                    Match otherMatch;
                    class_2487 matchNbt = (class_2487)matchNbtElement;
                    int otherWorldId = (Integer)matchNbt.method_10550("world").orElseThrow();
                    Match match = new Match((LongSet)new LongOpenHashSet((long[])worldNbt.method_10565("matching").orElseThrow()), (LongSet)new LongOpenHashSet((long[])worldNbt.method_10565("mismatching").orElseThrow()));
                    World otherWorld = (World)this.worlds.get(otherWorldId);
                    Match match2 = otherMatch = otherWorld != null ? (Match)otherWorld.matchingWorlds.get(world.id) : null;
                    if (otherMatch != null) {
                        otherMatch.addAll(match);
                        world.matchingWorlds.put(otherWorldId, (Object)otherMatch);
                        continue;
                    }
                    world.matchingWorlds.put(otherWorldId, (Object)match);
                }
                world.nonMatchingWorlds.addAll((IntCollection)IntArrayList.wrap((int[])((int[])worldNbt.method_10561("non_matching").orElseThrow())));
                if (world.version == CURRENT_SAVE_VERSION) {
                    this.worlds.put(world.id, (Object)world);
                    continue;
                }
                this.outdatedWorlds.add(world);
            }
            this.nextWorldId = root.method_68083("next_world", 0);
        }
        this.currentWorldId = this.nextWorldId++;
        World currentWorld = new World(this.currentWorldId, CURRENT_SAVE_VERSION);
        this.worlds.put(this.currentWorldId, (Object)currentWorld);
        for (World world : this.worlds.values()) {
            if (!world.knownRegions.isEmpty() || world.mergingIntoWorld != -1 || world == currentWorld) continue;
            this.merge(world, currentWorld);
        }
    }

    private World getWorldForCommand(FabricClientCommandSource source, int id) {
        World world = (World)this.worlds.get(id);
        if (world == null) {
            source.sendError((class_2561)class_2561.method_43469((String)"No active world with id %s. Run `/bobby worlds` for a list of available worlds.", (Object[])new Object[]{id}));
            return null;
        }
        return world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userRequestedFork(FabricClientCommandSource source) {
        this.lock.writeLock().lock();
        try {
            World previousWorld = (World)this.worlds.get(this.currentWorldId);
            this.currentWorldId = this.nextWorldId++;
            this.worlds.put(this.currentWorldId, (Object)new World(this.currentWorldId, CURRENT_SAVE_VERSION));
            World currentWorld = (World)this.worlds.get(this.currentWorldId);
            currentWorld.nonMatchingWorlds.add(previousWorld.id);
            previousWorld.nonMatchingWorlds.add(currentWorld.id);
            this.metaDirty = true;
            this.dirty = true;
            source.sendFeedback((class_2561)class_2561.method_43469((String)"Created and switched to world %s.", (Object[])new Object[]{currentWorld}));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userRequestedMerge(FabricClientCommandSource source, int sourceId, int targetId) {
        this.lock.writeLock().lock();
        try {
            World sourceWorld = this.getWorldForCommand(source, sourceId);
            World targetWorld = this.getWorldForCommand(source, targetId);
            if (sourceWorld == null || targetWorld == null) {
                return;
            }
            while (targetWorld.mergingIntoWorld != -1) {
                targetWorld = (World)this.worlds.get(targetWorld.mergingIntoWorld);
            }
            if (targetWorld == sourceWorld) {
                source.sendError((class_2561)class_2561.method_43471((String)"Target world is already being merged into source world."));
                return;
            }
            this.merge(sourceWorld, targetWorld);
            source.sendFeedback((class_2561)class_2561.method_43469((String)"Queued merge of %s into %s. Run `/bobby worlds` for status.", (Object[])new Object[]{sourceWorld, targetWorld}));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void sendInfo(FabricClientCommandSource source, boolean loadAllMetadata) {
        this.lock.writeLock().lock();
        try {
            this.sendInfoWithLock(source, loadAllMetadata);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void sendInfoWithLock(FabricClientCommandSource source, boolean loadAllMetadata) {
        boolean allMetadataAvailable = true;
        source.sendFeedback((class_2561)class_2561.method_43470((String)""));
        ArrayList<World> sortedWorlds = new ArrayList<World>((Collection<World>)this.worlds.values());
        sortedWorlds.sort(Comparator.comparing(it -> it.id));
        for (World world : sortedWorlds) {
            long unloadedRegions = world.knownRegions.size() - world.regions.size();
            long knownChunks = this.countFingerprints(world, it -> it != 0L);
            long lowQualityChunks = this.countFingerprints(world, it -> it == 1L);
            long unknownChunks = this.countFingerprints(world, it -> it == 0L);
            long unloadedChunks = unloadedRegions * 1024L;
            if (unloadedRegions > 0L || unknownChunks > 0L) {
                allMetadataAvailable = false;
            }
            source.sendFeedback((class_2561)class_2561.method_43469((String)"World %s:", (Object[])new Object[]{world}));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"  - Regions: %s (%s loaded, %s loading)", (Object[])new Object[]{world.knownRegions.size(), world.regions.size(), world.loadingRegions.size()}));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"  - Chunks: %s (%s low quality)", (Object[])new Object[]{knownChunks, lowQualityChunks}));
            if (unknownChunks > 0L) {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"             (+ up to %s of unknown state)", (Object[])new Object[]{unknownChunks}));
            }
            if (unloadedChunks > 0L) {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"             (+ up to %s in non-loaded regions)", (Object[])new Object[]{unloadedChunks}));
            }
            if (!world.matchingWorlds.isEmpty()) {
                source.sendFeedback((class_2561)class_2561.method_43471((String)"  - Matching against other worlds:"));
                for (World otherWorld : sortedWorlds) {
                    Match match = (Match)world.matchingWorlds.get(otherWorld.id);
                    if (match == null) continue;
                    source.sendFeedback((class_2561)class_2561.method_43469((String)"    - World %s: %s/%s chunks matching/mismatching", (Object[])new Object[]{otherWorld, match.matching.size(), match.mismatching.size()}));
                }
            }
            if (!world.nonMatchingWorlds.isEmpty()) {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"  - Not matching against worlds: %s", (Object[])new Object[]{world.nonMatchingWorlds.intStream().sorted().mapToObj(String::valueOf).collect(Collectors.joining(", "))}));
            }
            if (world.mergingIntoWorld == -1) continue;
            source.sendFeedback((class_2561)class_2561.method_43469((String)"  - In the process of being merged into %s", (Object[])new Object[]{world.mergingIntoWorld}));
            MergeState mergeState = world.mergeState;
            if (mergeState == null) continue;
            source.sendFeedback((class_2561)class_2561.method_43469((String)"    - Region: %s", (Object[])new Object[]{mergeState.activeRegion}));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"    - Stage: %s", (Object[])new Object[]{mergeState.stage}));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"    - Copy jobs: %s/%s/%s pending/active/done", (Object[])new Object[]{copyExecutor.queueSize(), copyExecutor.activeWorkers(), mergeState.finishedJobs.size()}));
        }
        if (!this.outdatedWorlds.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"Outdated worlds (run `/bobby upgrade`):"));
            for (World world : this.outdatedWorlds) {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"  - World %s (%s regions)", (Object[])new Object[]{world, world.knownRegions.size()}));
            }
        }
        if (!this.computeLegacyFingerprintJobs.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"Fingerprint jobs: %s remaining", (Object[])new Object[]{this.computeLegacyFingerprintJobs.size()}));
        }
        if (!this.workQueue.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"Work queue: %s jobs, bocked on %s (%s)", (Object[])new Object[]{this.workQueue.size(), this.workQueue.peek(), this.workQueueBlockedOn}));
        }
        if (allMetadataAvailable) {
            return;
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)""));
        if (loadAllMetadata) {
            ArrayList futures = new ArrayList();
            for (World world : sortedWorlds) {
                LongIterator longIterator = world.knownRegions.iterator();
                while (longIterator.hasNext()) {
                    long regionCoord = (Long)longIterator.next();
                    if (world.regions.containsKey(regionCoord)) continue;
                    futures.add(world.loadRegion(RegionPos.fromLong(regionCoord)));
                }
            }
            if (!futures.isEmpty()) {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"Loading %s regions.. (run `/bobby worlds` to see progress)", (Object[])new Object[]{futures.size()}));
                CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenRunAsync(() -> this.sendInfo(source, true), (Executor)class_310.method_1551());
                return;
            }
            for (World world : sortedWorlds) {
                for (Long2ObjectMap.Entry regionEntry : world.regions.long2ObjectEntrySet()) {
                    for (Long2LongMap.Entry entry : ((Region)regionEntry.getValue()).chunkFingerprints.long2LongEntrySet()) {
                        long chunkCoord = entry.getLongKey();
                        long fingerprint = entry.getLongValue();
                        if (fingerprint != 0L) continue;
                        futures.add(this.computeLegacyFingerprint(world, new class_1923(chunkCoord), (class_1937)source.getWorld()));
                    }
                }
            }
            if (!futures.isEmpty()) {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"Computing fingerprints for %s chunks.. (run `/bobby worlds` to see progress)", (Object[])new Object[]{futures.size()}));
                CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenRunAsync(() -> this.sendInfo(source, false), (Executor)class_310.method_1551());
            }
        } else {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"Run `/bobby worlds full` to load non-loaded regions and compute the state of currently unknown chunks."));
        }
    }

    private long countFingerprints(World world, Long2BooleanFunction filter) {
        return world.regions.values().stream().mapToLong(region -> region.chunkFingerprints.values().longStream().filter((LongPredicate)filter).count()).sum();
    }

    private static /* synthetic */ void lambda$new$1(class_310 client, class_2561 text) {
        client.field_1705.method_1743().method_1812(text);
    }

    private class World {
        private final int id;
        private int version;
        private final LongSet knownRegions = new LongOpenHashSet();
        private final Long2ObjectMap<CompletableFuture<?>> loadingRegions = new Long2ObjectOpenHashMap();
        private final Long2ObjectMap<Region> regions = new Long2ObjectOpenHashMap();
        private final Long2ObjectMap<Region> regionUpdates = new Long2ObjectOpenHashMap();
        private int mergingIntoWorld = -1;
        private final Int2ObjectMap<Match> matchingWorlds = new Int2ObjectOpenHashMap();
        private final IntSet nonMatchingWorlds = new IntOpenHashSet();
        private final FakeChunkStorage storage;
        private MergeState mergeState;
        private boolean metaDirty;
        private boolean contentDirty;

        public World(int id, int version) {
            this.id = id;
            this.version = version;
            this.storage = FakeChunkStorage.getFor(this.directory(), true);
        }

        public String toString() {
            return String.valueOf(this.id);
        }

        public Path directory() {
            if (this.id == 0) {
                return Worlds.this.directory;
            }
            return Worlds.this.directory.resolve(String.valueOf(this.id));
        }

        private Path regionFile(RegionPos pos) {
            return this.directory().resolve("r." + pos.x() + "." + pos.z() + ".meta");
        }

        public void markMetaDirty() {
            Worlds.this.dirty = true;
            this.metaDirty = true;
        }

        public void markContentDirty() {
            Worlds.this.dirty = true;
            this.contentDirty = true;
        }

        public void setFingerprint(class_1923 chunkPos, long fingerprint) {
            Region region;
            RegionPos regionPos = RegionPos.from(chunkPos);
            long chunkCoord = chunkPos.method_8324();
            long regionCoord = regionPos.toLong();
            if (this.knownRegions.add(regionCoord)) {
                this.markMetaDirty();
                this.regions.put(regionCoord, (Object)new Region());
            }
            if ((region = (Region)this.regions.get(regionCoord)) == null && (region = (Region)this.regionUpdates.get(regionCoord)) == null) {
                region = new Region();
                this.regionUpdates.put(regionCoord, (Object)region);
                this.loadRegion(regionPos);
            }
            if (region.chunkFingerprints.put(chunkCoord, fingerprint) != fingerprint) {
                region.chunks.put(chunkCoord, Worlds.this.now);
                region.dirty = true;
                this.markContentDirty();
            }
        }

        public Match getMatch(World otherWorld) {
            Match match = (Match)this.matchingWorlds.get(otherWorld.id);
            if (match == null && (match = (Match)otherWorld.matchingWorlds.get(this.id)) == null) {
                match = new Match((LongSet)new LongOpenHashSet(), (LongSet)new LongOpenHashSet());
                this.matchingWorlds.put(otherWorld.id, (Object)match);
                otherWorld.matchingWorlds.put(this.id, (Object)match);
            }
            return match;
        }

        public CompletableFuture<?> loadRegion(RegionPos regionPos) {
            long regionCoord = regionPos.toLong();
            assert (Worlds.this.lock.isWriteLockedByCurrentThread());
            assert (this.knownRegions.contains(regionCoord));
            CompletableFuture existingFuture = (CompletableFuture)this.loadingRegions.get(regionCoord);
            if (existingFuture != null) {
                return existingFuture;
            }
            CompletableFuture future = new CompletableFuture();
            this.loadingRegions.put(regionCoord, future);
            RegionLoadingJob loadingJob = new RegionLoadingJob(this, regionPos);
            Worlds.this.regionLoadingJobs.add(loadingJob);
            regionLoadingExecutor.execute(loadingJob);
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeRegionToDisk(RegionPos regionPos, class_2487 nbt) throws IOException {
            Files.createDirectories(Worlds.this.directory, new FileAttribute[0]);
            Path tmpFile = Files.createTempFile(Worlds.this.directory, "region", ".meta", new FileAttribute[0]);
            try {
                try (OutputStream out = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                    class_2507.method_10634((class_2487)nbt, (OutputStream)out);
                }
                Files.move(tmpFile, this.regionFile(regionPos), StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                Files.deleteIfExists(tmpFile);
            }
        }
    }

    private static class Region {
        private final Long2LongMap chunks = new Long2LongOpenHashMap();
        private final Long2LongMap chunkFingerprints = new Long2LongOpenHashMap();
        private boolean dirty;

        private Region() {
        }

        public static Region read(Path file, RegionPos pos) throws IOException {
            class_2487 root;
            if (Files.notExists(file, new LinkOption[0])) {
                Region region = new Region();
                pos.getContainedChunks().forEach(chunkPos -> {
                    long chunkCoord = chunkPos.method_8324();
                    region.chunks.put(chunkCoord, 1L);
                    region.chunkFingerprints.put(chunkCoord, 0L);
                });
                return region;
            }
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                root = class_2507.method_10629((InputStream)in, (class_2505)class_2505.method_53898());
            }
            long[] chunkCoords = root.method_10565("chunk_coords").orElseGet(() -> new long[0]);
            long[] chunkAges = root.method_10565("chunk_ages").orElseGet(() -> new long[0]);
            long[] chunkFingerprints = root.method_10565("chunk_fingerprints").orElseGet(() -> new long[0]);
            Region region = new Region();
            region.chunks.putAll((Map)new Long2LongArrayMap(chunkCoords, chunkAges));
            region.chunkFingerprints.putAll((Map)new Long2LongArrayMap(chunkCoords, chunkFingerprints));
            return region;
        }

        public class_2487 saveToNbt() {
            long[] chunkCoords = new long[this.chunks.size()];
            long[] chunkAges = new long[chunkCoords.length];
            long[] chunkFingerprints = new long[chunkCoords.length];
            int i = 0;
            for (Long2LongMap.Entry entry : this.chunks.long2LongEntrySet()) {
                long coord;
                chunkCoords[i] = coord = entry.getLongKey();
                chunkAges[i] = entry.getLongValue();
                chunkFingerprints[i] = this.chunkFingerprints.get(coord);
                ++i;
            }
            class_2487 root = new class_2487();
            root.method_10564("chunk_coords", chunkCoords);
            root.method_10564("chunk_ages", chunkAges);
            root.method_10564("chunk_fingerprints", chunkFingerprints);
            return root;
        }
    }

    private record Match(LongSet matching, LongSet mismatching) {
        public void addAll(Match other) {
            this.matching.addAll((LongCollection)other.matching);
            this.mismatching.addAll((LongCollection)other.mismatching);
        }
    }

    private static class ComputeLegacyFingerprintJob
    implements Runnable {
        private final World world;
        private final class_1923 chunkPos;
        private final class_1937 mcWorld;
        private final CompletableFuture<Long> future = new CompletableFuture();
        private volatile Long result;

        private ComputeLegacyFingerprintJob(World world, class_1923 chunkPos, class_1937 mcWorld) {
            this.world = world;
            this.chunkPos = chunkPos;
            this.mcWorld = mcWorld;
        }

        @Override
        public void run() {
            class_2487 nbt = this.world.storage.loadTag(this.chunkPos).join().orElse(null);
            if (nbt == null) {
                this.result = 0L;
                return;
            }
            class_2818 chunk = (class_2818)ChunkSerializer.deserialize(this.chunkPos, nbt, this.mcWorld).getLeft();
            this.result = ChunkSerializer.fingerprint(chunk);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComputeLegacyFingerprintJob that = (ComputeLegacyFingerprintJob)o;
            return this.world.id == that.world.id && this.chunkPos.equals((Object)that.chunkPos);
        }

        public int hashCode() {
            return this.world.id * 127 + RegionPos.hashCode(this.chunkPos.method_8324());
        }
    }

    private static class RegionLoadingJob
    implements Runnable {
        private final World world;
        private final RegionPos regionPos;
        private volatile Region result;

        private RegionLoadingJob(World world, RegionPos regionPos) {
            this.world = world;
            this.regionPos = regionPos;
        }

        @Override
        public void run() {
            Path file = this.world.regionFile(this.regionPos);
            try {
                this.result = Region.read(file, this.regionPos);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load " + String.valueOf(file), (Throwable)e);
            }
            finally {
                if (this.result == null) {
                    this.result = new Region();
                }
            }
        }
    }

    private static class MergeState {
        private volatile MergeStage stage = MergeStage.BlockedByOtherMerge;
        private RegionPos activeRegion;
        private final Queue<CopyJob> activeJobs = new ArrayDeque<CopyJob>();
        private final List<CopyJob> finishedJobs = new ArrayList<CopyJob>();

        private MergeState() {
        }
    }

    private static enum MergeStage {
        BlockedByOtherMerge,
        BlockedByPreviouslyQueuedWrites,
        WaitForPreviouslyQueuedWrites,
        Idle,
        WaitForRegion,
        Copying,
        Syncing,
        WriteTargetMeta,
        SyncTargetMeta,
        DeleteSourceMeta,
        DeleteSourceStorage,
        Done;

    }

    private static class CopyJob
    implements Runnable {
        private final World source;
        private final World target;
        private final class_1923 chunkPos;
        private final long sourceAge;
        private final long targetAge;
        private long age;
        private volatile boolean done;

        private CopyJob(World source, World target, class_1923 chunkPos, long sourceAge, long targetAge) {
            this.source = source;
            this.target = target;
            this.chunkPos = chunkPos;
            this.sourceAge = sourceAge;
            this.targetAge = targetAge;
        }

        @Override
        public void run() {
            class_2487 nbt = this.source.storage.loadTag(this.chunkPos).join().orElse(null);
            if (nbt == null) {
                this.done = true;
                return;
            }
            if (this.sourceAge == 1L) {
                this.age = nbt.method_68080("age", 0L);
                if (this.age < this.targetAge) {
                    this.done = true;
                    return;
                }
            } else {
                this.age = this.sourceAge;
            }
            this.target.storage.save(this.chunkPos, nbt);
            ((class_4698)this.target.storage.method_39800()).method_23698(false).join();
            this.done = true;
        }
    }
}

