/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.color;

import eu.pb4.placeholders.impl.GeneralUtils;

public record HSV(float h, float s, float v) {
    public static HSV fromRgb(int rgb) {
        float b = (float)(rgb % 256) / 255.0f;
        float g = (float)((rgb >>= 8) % 256) / 255.0f;
        float r = (float)((rgb >>= 8) % 256) / 255.0f;
        float cmax = Math.max(r, Math.max(g, b));
        float cmin = Math.min(r, Math.min(g, b));
        float diff = cmax - cmin;
        float h = -1.0f;
        float s = -1.0f;
        if (cmax == cmin) {
            h = 0.0f;
        } else if (cmax == r) {
            h = (0.1666f * ((g - b) / diff) + 1.0f) % 1.0f;
        } else if (cmax == g) {
            h = (0.1666f * ((b - r) / diff) + 0.333f) % 1.0f;
        } else if (cmax == b) {
            h = (0.1666f * ((r - g) / diff) + 0.666f) % 1.0f;
        }
        s = cmax == 0.0f ? 0.0f : diff / cmax;
        return new HSV(h, s, cmax);
    }

    public int toRgb() {
        return HSV.toRgb(this.h, this.s, this.v);
    }

    public static int toRgb(float hue, float saturation, float value) {
        int h = (int)(hue * 6.0f) % 6;
        float f = hue * 6.0f - (float)h;
        float p = value * (1.0f - saturation);
        float q = value * (1.0f - f * saturation);
        float t = value * (1.0f - (1.0f - f) * saturation);
        return switch (h) {
            case 0 -> GeneralUtils.rgbToInt(value, t, p);
            case 1 -> GeneralUtils.rgbToInt(q, value, p);
            case 2 -> GeneralUtils.rgbToInt(p, value, t);
            case 3 -> GeneralUtils.rgbToInt(p, q, value);
            case 4 -> GeneralUtils.rgbToInt(t, p, value);
            case 5 -> GeneralUtils.rgbToInt(value, p, q);
            default -> 0;
        };
    }
}

