/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.impl.placeholder.builtin;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.arguments.StringArgs;
import eu.pb4.placeholders.impl.GeneralUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_2926;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_9011;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ServerPlaceholders {
    public static void register() {
        Placeholders.register(class_2960.method_60655((String)"server", (String)"tps"), (ctx, arg) -> {
            double tps = (float)TimeUnit.SECONDS.toMillis(1L) / Math.max(ctx.server().method_54832(), ctx.server().method_54833().method_54749());
            Object format = "%.1f";
            if (arg != null) {
                try {
                    int x = Integer.parseInt(arg);
                    format = "%." + x + "f";
                }
                catch (Exception e) {
                    format = "%.1f";
                }
            }
            return PlaceholderResult.value(String.format((String)format, tps));
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"tps_colored"), (ctx, arg) -> {
            double tps = (float)TimeUnit.SECONDS.toMillis(1L) / Math.max(ctx.server().method_54832(), ctx.server().method_54833().method_54749());
            Object format = "%.1f";
            if (arg != null) {
                try {
                    int x = Integer.parseInt(arg);
                    format = "%." + x + "f";
                }
                catch (Exception e) {
                    format = "%.1f";
                }
            }
            return PlaceholderResult.value((class_2561)class_2561.method_43470((String)String.format((String)format, tps)).method_27692(tps > 19.0 ? class_124.field_1060 : (tps > 16.0 ? class_124.field_1065 : class_124.field_1061)));
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"mspt"), (ctx, arg) -> PlaceholderResult.value(String.format("%.0f", Float.valueOf(ctx.server().method_54832()))));
        Placeholders.register(class_2960.method_60655((String)"server", (String)"mspt_colored"), (ctx, arg) -> {
            float x = ctx.server().method_54832();
            return PlaceholderResult.value((class_2561)class_2561.method_43470((String)String.format("%.0f", Float.valueOf(x))).method_27692(x < 45.0f ? class_124.field_1060 : (x < 51.0f ? class_124.field_1065 : class_124.field_1061)));
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"time"), (ctx, arg) -> {
            SimpleDateFormat format = new SimpleDateFormat(arg != null ? arg : "HH:mm:ss");
            return PlaceholderResult.value(format.format(new Date(System.currentTimeMillis())));
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"time_new"), (ctx, arg) -> {
            StringArgs args = arg == null ? StringArgs.empty() : StringArgs.full(arg, ' ', ':');
            DateTimeFormatter format = DateTimeFormatter.ofPattern(args.get("format", "HH:mm:ss"));
            LocalDateTime date = args.get("zone") != null ? LocalDateTime.now(ZoneId.of(args.get("zone", ""))) : LocalDateTime.now();
            return PlaceholderResult.value(format.format(date));
        });
        Object ref = new Object(){
            WeakReference<MinecraftServer> server;
            long ms;
        };
        Placeholders.register(class_2960.method_60655((String)"server", (String)"uptime"), (arg_0, arg_1) -> ServerPlaceholders.lambda$register$6(ref, arg_0, arg_1));
        Placeholders.register(class_2960.method_60655((String)"server", (String)"version"), (ctx, arg) -> PlaceholderResult.value(ctx.server().method_3827()));
        Placeholders.register(class_2960.method_60655((String)"server", (String)"motd"), (ctx, arg) -> {
            class_2926 metadata = ctx.server().method_3765();
            if (metadata == null) {
                return PlaceholderResult.invalid("Server metadata missing!");
            }
            return PlaceholderResult.value(metadata.comp_1273());
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"mod_version"), (ctx, arg) -> {
            Optional container;
            if (arg != null && (container = FabricLoader.getInstance().getModContainer(arg)).isPresent()) {
                return PlaceholderResult.value((class_2561)class_2561.method_43470((String)((ModContainer)container.get()).getMetadata().getVersion().getFriendlyString()));
            }
            return PlaceholderResult.invalid("Invalid argument");
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"mod_name"), (ctx, arg) -> {
            Optional container;
            if (arg != null && (container = FabricLoader.getInstance().getModContainer(arg)).isPresent()) {
                return PlaceholderResult.value((class_2561)class_2561.method_43470((String)((ModContainer)container.get()).getMetadata().getName()));
            }
            return PlaceholderResult.invalid("Invalid argument");
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"brand"), (ctx, arg) -> PlaceholderResult.value((class_2561)class_2561.method_43470((String)ctx.server().getServerModName())));
        Placeholders.register(class_2960.method_60655((String)"server", (String)"mod_count"), (ctx, arg) -> PlaceholderResult.value((class_2561)class_2561.method_43470((String)("" + FabricLoader.getInstance().getAllMods().size()))));
        Placeholders.register(class_2960.method_60655((String)"server", (String)"mod_description"), (ctx, arg) -> {
            Optional container;
            if (arg != null && (container = FabricLoader.getInstance().getModContainer(arg)).isPresent()) {
                return PlaceholderResult.value((class_2561)class_2561.method_43470((String)((ModContainer)container.get()).getMetadata().getDescription()));
            }
            return PlaceholderResult.invalid("Invalid argument");
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"name"), (ctx, arg) -> PlaceholderResult.value(ctx.server().method_16898()));
        Placeholders.register(class_2960.method_60655((String)"server", (String)"used_ram"), (ctx, arg) -> {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapUsage = memoryMXBean.getHeapMemoryUsage();
            return PlaceholderResult.value(Objects.equals(arg, "gb") ? String.format("%.1f", Float.valueOf((float)heapUsage.getUsed() / 1.0737418E9f)) : String.format("%d", heapUsage.getUsed() / 0x100000L));
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"max_ram"), (ctx, arg) -> {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapUsage = memoryMXBean.getHeapMemoryUsage();
            return PlaceholderResult.value(Objects.equals(arg, "gb") ? String.format("%.1f", Float.valueOf((float)heapUsage.getMax() / 1.0737418E9f)) : String.format("%d", heapUsage.getMax() / 0x100000L));
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"online"), (ctx, arg) -> PlaceholderResult.value(String.valueOf(ctx.server().method_3760().method_14574())));
        Placeholders.register(class_2960.method_60655((String)"server", (String)"max_players"), (ctx, arg) -> PlaceholderResult.value(String.valueOf(ctx.server().method_3760().method_14592())));
        Placeholders.register(class_2960.method_60655((String)"server", (String)"objective_name_top"), (ctx, arg) -> {
            String[] args = arg.split(" ");
            if (args.length >= 2) {
                class_2995 scoreboard = ctx.server().method_3845();
                class_266 scoreboardObjective = scoreboard.method_1170(args[0]);
                if (scoreboardObjective == null) {
                    return PlaceholderResult.invalid("Invalid objective!");
                }
                try {
                    int position = Integer.parseInt(args[1]);
                    ArrayList<class_9011> scoreboardEntries = new ArrayList<class_9011>(scoreboard.method_1184(scoreboardObjective));
                    scoreboardEntries.sort(Comparator.comparingInt(class_9011::comp_2128).reversed());
                    class_9011 scoreboardEntry = (class_9011)scoreboardEntries.get(position - 1);
                    return PlaceholderResult.value(scoreboardEntry.method_55387());
                }
                catch (Exception e) {
                    return PlaceholderResult.invalid("Invalid position!");
                }
            }
            return PlaceholderResult.invalid("Not enough arguments!");
        });
        Placeholders.register(class_2960.method_60655((String)"server", (String)"objective_score_top"), (ctx, arg) -> {
            String[] args = arg.split(" ");
            if (args.length >= 2) {
                class_2995 scoreboard = ctx.server().method_3845();
                class_266 scoreboardObjective = scoreboard.method_1170(args[0]);
                if (scoreboardObjective == null) {
                    return PlaceholderResult.invalid("Invalid objective!");
                }
                try {
                    int position = Integer.parseInt(args[1]);
                    ArrayList<class_9011> scoreboardEntries = new ArrayList<class_9011>(scoreboard.method_1184(scoreboardObjective));
                    scoreboardEntries.sort(Comparator.comparingInt(class_9011::comp_2128).reversed());
                    class_9011 scoreboardEntry = (class_9011)scoreboardEntries.get(position - 1);
                    return PlaceholderResult.value(String.valueOf(scoreboardEntry.comp_2128()));
                }
                catch (Exception e) {
                    return PlaceholderResult.invalid("Invalid position!");
                }
            }
            return PlaceholderResult.invalid("Not enough arguments!");
        });
    }

    private static /* synthetic */ PlaceholderResult lambda$register$6(1 ref, PlaceholderContext ctx, String arg) {
        if (ref.server == null || !ref.server.refersTo(ctx.server())) {
            ref.server = new WeakReference<MinecraftServer>(ctx.server());
            ref.ms = System.currentTimeMillis() - (long)ctx.server().method_3780() * 50L;
        }
        return PlaceholderResult.value(arg != null ? DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - ref.ms), (String)arg, (boolean)true) : GeneralUtils.durationToString((System.currentTimeMillis() - ref.ms) / 1000L));
    }
}

