/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.qendolin.betterclouds.clouds.Resources;
import com.qendolin.betterclouds.compat.GLCompat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_238;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_3545;
import net.minecraft.class_4588;
import net.minecraft.class_9801;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL32;

public class Debug {
    public static int profileInterval = 0;
    public static boolean frustumCulling = false;
    public static boolean generatorPause = false;
    public static int animationPause = -1;
    public static boolean generatorForceUpdate = false;
    public static final List<class_3545<class_238, Boolean>> frustumCulledBoxes = new ArrayList<class_3545<class_238, Boolean>>();
    private static BuiltBufferRenderer renderer = null;

    private static void clearFrustumCulledBoxes() {
        if (frustumCulling) {
            frustumCulledBoxes.clear();
        } else if (!frustumCulledBoxes.isEmpty()) {
            frustumCulledBoxes.clear();
        }
    }

    public static void addFrustumCulledBox(class_238 box, boolean visible) {
        if (!frustumCulling) {
            return;
        }
        frustumCulledBoxes.add((class_3545<class_238, Boolean>)new class_3545((Object)box, (Object)visible));
    }

    public static void render(Resources res, Vector3d cam) {
        if (!frustumCulling) {
            Debug.clearFrustumCulledBoxes();
            return;
        }
        if (frustumCulledBoxes.isEmpty()) {
            return;
        }
        if (renderer == null) {
            renderer = new BuiltBufferRenderer();
        }
        GLCompat.glCompat.pushDebugGroupDev("Debug Draw");
        class_287 vertices = class_289.method_1348().method_60827(VertexFormat.class_5596.field_29344, class_290.field_1576);
        Debug.drawFrustumCulledBoxes((class_4588)vertices, cam);
        res.debugShader().bind();
        res.debugShader().uModelViewMatrix.setMat4(RenderSystem.getModelViewMatrix());
        res.debugShader().uProjectionMatrix.setMat4(RenderSystem.getProjectionMatrix());
        class_9801 built = vertices.method_60794();
        if (built != null) {
            ByteBuffer vertexBuffer = built.method_60818();
            int vertexCount = built.method_60822().comp_750();
            renderer.render(vertexBuffer, vertexCount);
            built.close();
        }
        Debug.clearFrustumCulledBoxes();
        GLCompat.glCompat.popDebugGroup();
    }

    private static void drawFrustumCulledBoxes(class_4588 vertices, Vector3d cam) {
        for (class_3545<class_238, Boolean> pair : frustumCulledBoxes) {
            class_238 box = (class_238)pair.method_15442();
            if (((Boolean)pair.method_15441()).booleanValue()) {
                Debug.drawBox(cam, vertices, box, 0.6f, 1.0f, 0.5f, 1.0f);
                continue;
            }
            Debug.drawBox(cam, vertices, box, 1.0f, 0.6f, 0.5f, 1.0f);
        }
    }

    public static void drawBox(Vector3d cam, class_4588 vertices, class_238 box, float red, float green, float blue, float alpha) {
        float minX = (float)(box.field_1323 - cam.x);
        float minY = (float)(box.field_1322 - cam.y);
        float minZ = (float)(box.field_1321 - cam.z);
        float maxX = (float)(box.field_1320 - cam.x);
        float maxY = (float)(box.field_1325 - cam.y);
        float maxZ = (float)(box.field_1324 - cam.z);
        Debug.addLine(vertices, minX, minY, minZ, maxX, minY, minZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, minY, maxZ, maxX, minY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, maxY, maxZ, maxX, maxY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, maxY, minZ, maxX, maxY, minZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, minY, minZ, minX, maxY, minZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, minY, maxZ, minX, maxY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, maxX, minY, maxZ, maxX, maxY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, maxX, minY, minZ, maxX, maxY, minZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, minY, minZ, minX, minY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, minX, maxY, minZ, minX, maxY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, maxX, maxY, minZ, maxX, maxY, maxZ, red, green, blue, alpha);
        Debug.addLine(vertices, maxX, minY, minZ, maxX, minY, maxZ, red, green, blue, alpha);
    }

    private static void addLine(class_4588 vertices, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha) {
        float nx = x2 - x1;
        float ny = y2 - y1;
        float nz = z2 - z1;
        float l = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        Debug.addVertex(vertices, x1, y1, z1, nx /= l, ny /= l, nz /= l, red, green, blue, alpha);
        Debug.addVertex(vertices, x2, y2, z2, nx, ny, nz, red, green, blue, alpha);
    }

    private static void addVertex(class_4588 vertexConsumer, float x, float y, float z, float nx, float ny, float nz, float red, float green, float blue, float alpha) {
        vertexConsumer.method_22912(x, y, z).method_22915(red, green, blue, alpha);
    }

    public static boolean isProfilingEnabled() {
        return profileInterval > 0;
    }

    private static class BuiltBufferRenderer {
        private final int vboId;
        private int vboSize = 0;
        private final int vaoId;

        public BuiltBufferRenderer() {
            int prevVao = GL32.glGetInteger((int)34229);
            this.vaoId = GL32.glGenVertexArrays();
            GL32.glBindVertexArray((int)this.vaoId);
            GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_VERTEX_ARRAY, this.vaoId, "debug_vao");
            GL32.glEnableVertexAttribArray((int)0);
            GL32.glEnableVertexAttribArray((int)1);
            this.vboId = GL32.glGenBuffers();
            GL32.glBindBuffer((int)34962, (int)this.vboId);
            GLCompat.glCompat.objectLabelDev(GLCompat.glCompat.GL_BUFFER, this.vboId, "debug_vbo");
            GL32.glBindBuffer((int)34962, (int)0);
            GL32.glBindVertexArray((int)prevVao);
        }

        public void render(ByteBuffer buffer, int vertexCount) {
            if (buffer.remaining() == 0) {
                return;
            }
            int prevVao = GL32.glGetInteger((int)34229);
            GL32.glBindVertexArray((int)this.vaoId);
            GL32.glBindBuffer((int)34962, (int)this.vboId);
            if (buffer.remaining() > this.vboSize) {
                this.vboSize = buffer.remaining();
                GL32.glBufferData((int)34962, (ByteBuffer)buffer, (int)35040);
                int stride = 16;
                GL32.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)stride, (long)0L);
                GL32.glVertexAttribPointer((int)1, (int)4, (int)5121, (boolean)true, (int)stride, (long)12L);
            } else {
                GL32.glBufferSubData((int)34962, (long)0L, (ByteBuffer)buffer);
            }
            GL32.glDrawArrays((int)1, (int)0, (int)vertexCount);
            GL32.glBindVertexArray((int)prevVao);
        }
    }
}

