/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds.shaders;

import java.nio.FloatBuffer;
import org.apache.commons.lang3.NotImplementedException;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryUtil;

public abstract class Uniform {
    static final FloatBuffer UNIFORM_BUFFER = MemoryUtil.memAllocFloat((int)16);
    protected final String name;
    protected final int location;

    protected Uniform(String name, int location) {
        this.name = name;
        this.location = location;
    }

    public abstract void setMat4(Matrix4f var1);

    public abstract void setMat4(float[] var1, boolean var2);

    public abstract void setVec4(float var1, float var2, float var3, float var4);

    public abstract void setVec3(float var1, float var2, float var3);

    public abstract void setVec3(Vector3f var1);

    public abstract void setVec2(float var1, float var2);

    public abstract void setFloat(float var1);

    public abstract void setInt(int var1);

    public String toString() {
        return "Uniform{name='" + this.name + "', location=" + this.location + "}";
    }

    public static class Cached
    extends Uniform {
        private final float[] cache = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};

        protected Cached(String name, int location) {
            super(name, location);
        }

        @Override
        public void setMat4(Matrix4f mat) {
            throw new NotImplementedException();
        }

        @Override
        public void setMat4(float[] mat, boolean transpose) {
            throw new NotImplementedException();
        }

        @Override
        public void setVec4(float x, float y, float z, float w) {
            if (this.checkCache(x, y, z, w)) {
                return;
            }
            this.setCache(x, y, z, w);
            GL32.glUniform4f((int)this.location, (float)x, (float)y, (float)z, (float)w);
        }

        private boolean checkCache(float x, float y, float z, float w) {
            return x == this.cache[0] && y == this.cache[1] && z == this.cache[2] && w == this.cache[3];
        }

        private void setCache(float x, float y, float z, float w) {
            this.cache[0] = x;
            this.cache[1] = y;
            this.cache[2] = z;
            this.cache[3] = w;
        }

        @Override
        public void setVec3(Vector3f v) {
            this.setVec3(v.x, v.y, v.z);
        }

        @Override
        public void setVec3(float x, float y, float z) {
            if (this.checkCache(x, y, z, 0.0f)) {
                return;
            }
            this.setCache(x, y, z, 0.0f);
            GL32.glUniform3f((int)this.location, (float)x, (float)y, (float)z);
        }

        @Override
        public void setVec2(float x, float y) {
            if (this.checkCache(x, y, 0.0f, 0.0f)) {
                return;
            }
            this.setCache(x, y, 0.0f, 0.0f);
            GL32.glUniform2f((int)this.location, (float)x, (float)y);
        }

        @Override
        public void setFloat(float f) {
            if (this.checkCache(f, 0.0f, 0.0f, 0.0f)) {
                return;
            }
            this.setCache(f, 0.0f, 0.0f, 0.0f);
            GL32.glUniform1f((int)this.location, (float)f);
        }

        @Override
        public void setInt(int i) {
            throw new NotImplementedException();
        }
    }

    public static class Simple
    extends Uniform {
        protected Simple(String name, int location) {
            super(name, location);
        }

        @Override
        public void setMat4(Matrix4f mat) {
            mat.get(UNIFORM_BUFFER);
            UNIFORM_BUFFER.rewind();
            GL20.glUniformMatrix4fv((int)this.location, (boolean)false, (FloatBuffer)UNIFORM_BUFFER);
        }

        @Override
        public void setMat4(float[] mat, boolean transpose) {
            GL20.glUniformMatrix4fv((int)this.location, (boolean)transpose, (float[])mat);
        }

        @Override
        public void setVec4(float x, float y, float z, float w) {
            GL32.glUniform4f((int)this.location, (float)x, (float)y, (float)z, (float)w);
        }

        @Override
        public void setVec3(float x, float y, float z) {
            GL32.glUniform3f((int)this.location, (float)x, (float)y, (float)z);
        }

        @Override
        public void setVec3(Vector3f v) {
            GL32.glUniform3f((int)this.location, (float)v.x, (float)v.y, (float)v.z);
        }

        @Override
        public void setVec2(float x, float y) {
            GL32.glUniform2f((int)this.location, (float)x, (float)y);
        }

        @Override
        public void setFloat(float f) {
            GL32.glUniform1f((int)this.location, (float)f);
        }

        @Override
        public void setInt(int i) {
            GL32.glUniform1i((int)this.location, (int)i);
        }
    }

    public static class Noop
    extends Uniform {
        protected Noop(String name, int location) {
            super(name, location);
        }

        @Override
        public void setMat4(Matrix4f mat) {
        }

        @Override
        public void setMat4(float[] mat, boolean transpose) {
        }

        @Override
        public void setVec4(float x, float y, float z, float w) {
        }

        @Override
        public void setVec3(float x, float y, float z) {
        }

        @Override
        public void setVec3(Vector3f v) {
        }

        @Override
        public void setVec2(float x, float y) {
        }

        @Override
        public void setFloat(float f) {
        }

        @Override
        public void setInt(int i) {
        }
    }
}

