/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.util;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.qendolin.betterclouds.mixin.runtime.GlBackendAccessor;
import com.qendolin.betterclouds.mixin.runtime.GlResourceManagerAccessor;
import net.minecraft.class_1044;
import net.minecraft.class_10868;
import net.minecraft.class_5944;
import net.minecraft.class_6854;
import net.minecraft.class_9958;

public interface RenderHelper {
    public static int getTextureId(class_1044 texture) {
        GpuTexture gpuTexture = texture.method_68004();
        if (gpuTexture instanceof class_10868) {
            class_10868 glTexture = (class_10868)gpuTexture;
            return glTexture.method_68427();
        }
        throw new IllegalStateException("Texture is not a GlTexture");
    }

    public static int getTextureId(GpuTexture texture) {
        if (texture instanceof class_10868) {
            class_10868 glTexture = (class_10868)texture;
            return glTexture.method_68427();
        }
        throw new IllegalStateException("Texture is not a GlTexture");
    }

    public static void bindTexture(class_1044 texture) {
        RenderHelper.bindTexture(RenderHelper.getTextureId(texture));
    }

    public static void bindTexture(GpuTexture texture) {
        RenderHelper.bindTexture(RenderHelper.getTextureId(texture));
    }

    public static void bindTexture(int id) {
        GlStateManager._bindTexture((int)id);
    }

    public static Fog getFog() {
        class_9958 fog = RenderSystem.getShaderFog();
        return new Fog(fog);
    }

    public static void unbindShader() {
        GlBackendAccessor backend = (GlBackendAccessor)RenderSystem.getDevice();
        GlResourceManagerAccessor resourceManager = (GlResourceManagerAccessor)backend.getCommandEncoder();
        class_5944 current = resourceManager.getCurrentProgram();
        if (current != null) {
            current.method_34585();
        }
        resourceManager.setCurrentProgram(null);
        resourceManager.setCurrentPipeline(null);
    }

    public record Fog(float start, float end, class_6854 shape, float red, float green, float blue, float alpha) {
        public Fog(class_9958 fog) {
            this(fog.comp_3009(), fog.comp_3010(), fog.comp_3011(), fog.comp_3012(), fog.comp_3013(), fog.comp_3014(), fog.comp_3015());
        }

        public void apply() {
            RenderSystem.setShaderFog((class_9958)new class_9958(this.start, this.end, this.shape, this.red, this.green, this.blue, this.alpha));
        }
    }
}

