/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.fabric.impl.client.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import fuzs.forgeconfigapiport.fabric.impl.client.commands.arguments.EnumArgument;
import fuzs.forgeconfigapiport.fabric.impl.client.commands.arguments.ModIdArgument;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.config.ModConfigs;

public class ClientConfigCommand {
    private static final Dynamic2CommandExceptionType ERROR_NO_CONFIG = new Dynamic2CommandExceptionType((modId, type) -> class_2561.method_43469((String)"commands.config.noconfig", (Object[])new Object[]{modId, type}));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"config").then(((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"showfile").requires(cs -> cs.method_9259(0))).then(RequiredArgumentBuilder.argument((String)"mod", (ArgumentType)ModIdArgument.modIdArgument(ClientConfigCommand::hasAnyModConfig)).then(RequiredArgumentBuilder.argument((String)"type", EnumArgument.enumArgument(ModConfig.Type.class)).executes(ClientConfigCommand::showFile)))));
    }

    static boolean hasAnyModConfig(String modId) {
        return Stream.of(ModConfig.Type.values()).flatMap(type -> ModConfigs.getConfigFileNames(modId, type).stream()).findAny().isPresent();
    }

    private static int showFile(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        ModConfig.Type type;
        String modId = (String)context.getArgument("mod", String.class);
        List<String> configFileNames = ModConfigs.getConfigFileNames(modId, type = (ModConfig.Type)((Object)context.getArgument("type", ModConfig.Type.class)));
        if (configFileNames.isEmpty()) {
            throw ERROR_NO_CONFIG.create((Object)modId, (Object)type.method_15434());
        }
        for (String configFileName : configFileNames) {
            File f = new File(configFileName);
            class_5250 fileComponent = class_2561.method_43470((String)f.getName()).method_27692(class_124.field_1073);
            fileComponent.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10607(f)));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.config.getwithtype", (Object[])new Object[]{modId, type.method_15434(), fileComponent}));
        }
        return configFileNames.size();
    }
}

